<?php

require_once('SimgRender.php');

/**
 * 記事一覧レンダー
 * @author System Concept
 *
 */
class ArticleListRender extends SimgRender {

	/**
	 * レンダリング
	 * @param $event イベント
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 */
	public function rendering($event, $output, $parameter, $db) {
		if($output->hasPartial(PARTIAL_ARTICLE)) {
			$topic = simg_get_value($parameter->get(P_ITEM), '');
			$offset = simg_get_value($parameter->get(P_OFFSET), 0);
			$limit = ARTICLE_MAX_IN_PAGE;
			$output->assign(SMARTY_CURRENT_TOPIC, $topic);
			//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "ArticleListRender >> [%s]", print_r($db->getArticleByKeyForPaging($topic, $offset, $limit), true));
			$output->assign(SMARTY_ARTICLES, $db->getArticleByKeyForPaging($topic, $offset, $limit));
			$output->assign(SMARTY_NEXT_ARTICLE, ($db->isExistArticleByKeyForOffset($topic, $offset + $limit))? $this->makeJumpUrl($topic, $offset + $limit): null);
			$output->assign(SMARTY_BACK_ARTICLE, ($offset - $limit >= 0)? $this->makeJumpUrl($topic, $offset - $limit): null);
			$output->assign(SMARTY_CURRENT_OFFSET, $offset);
		}
	}
	/**
	 * ページ変更URL作成
	 * @param $topic カテゴリ
	 * @param $ofs 開始位置
	 * @return URL
	 */
	private function makeJumpUrl($topic, $ofs) {
		return simg_make_url(
			APP_NAME,
			array(
				SIMG_PARAM_EVENT => EVENT_TOPIC,
				P_ITEM => $topic,
				P_OFFSET => $ofs
			)
		);
	}
}

?>
