<?php

/**
 * 汎用ページャ
 * @author System Concept
 *
 */

require_once('SimgPager.php');

/**
 * 汎用ページャ
 * @author System Concept
 *
*/
class Pager extends SimgPager {

	/**
	 * ページング処理
	 * @param $event イベント
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 */
	public function paging($event, $output, $parameter, $db) {
		if($event == EVENT_INDEX) {
			$output->setTemplate(TEMPLATE_WELCOM);
		} else if($event == EVENT_ENTER) {
			$output->setTemplate(TEMPLATE_TOP);
		} else if($event == EVENT_TOPIC) {
			$output->setTemplate(TEMPLATE_ARTICLE);
		} else if($event == EVENT_MORE) {
			$output->setTemplate(TEMPLATE_DETAIL);
		} else if($event == EVENT_LOGOFF) {
			simg_redirect_by303(simg_make_url(APP_NAME));
			exit();
		} else if($event == EVENT_VOTE) {
			$output->setTemplate(TEMPLATE_RESULT);
		}
	}
}

?>
