﻿/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie.js"></script>
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
/*
// File: http://www.w3.org/TR/2000/REC-DOM-Level-2-Style-20001113/css.idl

#ifndef _CSS_IDL_
#define _CSS_IDL_

#include "dom.idl"
#include "stylesheets.idl"
#include "views.idl"

#pragma prefix "dom.w3c.org"
module css
{

  typedef dom::DOMString DOMString;
  typedef dom::Element Element;
  typedef dom::DOMImplementation DOMImplementation;

  interface CSSRule;
  interface CSSStyleSheet;
  interface CSSStyleDeclaration;
  interface CSSValue;
  interface Counter;
  interface Rect;
  interface RGBColor;
*/
/*CSSRuleList
 *Arrayで代用
function CSSRuleList {
    readonly attribute unsigned long    length;
    CSSRule            item(in unsigned long index);
  };
*/
/*CSSRule
 *CSSのルールを表現する。基底クラスなので削除不可。
 */
function CSSRule() {
  this.cssText = "";
/*CSSStyleSheet*/ this.parentStyleSheet;
/*CSSRule*/       this.parentRule = null;
  return this;
};
// RuleType
CSSRule.UNKNOWN_RULE                   = 0;
CSSRule.STYLE_RULE                     = 1;
CSSRule.CHARSET_RULE                   = 2;
CSSRule.IMPORT_RULE                    = 3;
CSSRule.MEDIA_RULE                     = 4;
CSSRule.FONT_FACE_RULE                 = 5;
CSSRule.PAGE_RULE                      = 6;

function CSSStyleRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.STYLE_RULE;
  this.selectorText = "";
/*CSSStyleDeclaration*/ this.style = new CSSStyleDeclaration();
  this.style.parentRule = this;
  return this;
};
CSSStyleRule.prototype = new CSSRule();
CSSStyleRule.constructor = CSSRule;

function CSSMediaRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.MEDIA_RULE;
/*stylesheets::MediaList*/ this.media = new MediaList();
/*CSSRuleList*/ this.cssRules = [];
  return this;
};
CSSMediaRule.prototype = new CSSRule();
CSSMediaRule.constructor = CSSRule;
/*long*/ CSSMediaRule.prototype.insertRule = function( /*string*/ rule, /*long*/ index) {
  this.cssRules.splice(index,rule,1);
  this.media.appendMedium(rule);
  return this;
};
/*void*/ CSSMediaRule.prototype.deleteRule = function( /*long*/ index) {
};

function CSSFontFaceRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.FONT_FACE_RULE;
/*CSSStyleDeclaration*/ this.style;
  return this;
};
CSSFontFaceRule.prototype = new CSSRule();
CSSFontFaceRule.constructor = CSSRule;

function CSSPageRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.PAGE_RULE;
  this.selectorText = "";
/*CSSStyleDeclaration*/ this.style;
  return this;
};
CSSPageRule.prototype = new CSSRule();
CSSPageRule.constructor = CSSRule;

function CSSImportRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.IMPORT_RULE;
  this.href = "";
/*stylesheets::MediaList*/ this.media = new MediaList();
/*CSSStyleSheet*/ this.styleSheet = null;
  return this;
};
CSSImportRule.prototype = new CSSRule();
CSSImportRule.constructor = CSSRule;

function CSSCharsetRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.CHARSET_RULE;
  this.encoding = "";
  return this;
};
CSSCharsetRule.prototype = new CSSRule();
CSSCharsetRule.constructor = CSSRule;

function CSSUnknownRule() {
  CSSRule.call(this, arguments);
  this.type = CSSRule.UNKNOWN_RULE;
  return this;
};
CSSUnknownRule.prototype = new CSSRule();
CSSUnknownRule.constructor = CSSRule;

/*CSSStyleDeclaration
 *CSSの宣言ブロックを表現。削除不可。
 */
function CSSStyleDeclaration() {
  this._list = []; //内部のリスト
  this._def = this._list._fontSize = this._list._opacity = null;
  return this;
};
CSSStyleDeclaration.prototype = {
  cssText : "",
  /*long*/ length : 0,
  /*CSSRule*/ parentRule : null,
  _urlreg : /url\(#([^)]+)/,
  /*getPropertyValueメソッド
   *CSSの値を返す。この値は継承ではなくて、明示的に表記されているもの
   */
/*string*/   getPropertyValue : function( /*string*/ propertyName) {
    var tg = this.getPropertyCSSValue(propertyName);
    if (tg) {                             //見つかった場合
      var tc = tg.cssText;
      return (tc.substring(tc.indexOf(":")+1, tc.length));
    } else {
      return "";
    }
  },
  /*getPropertyCSSValueメソッド
   *CSSValueオブジェクトを返す。このメソッドは判別に用いているので、削除不可。
   */
/*CSSValue*/ getPropertyCSSValue : function( /*string*/ propertyName) {
    var prop = propertyName,
        ti, tc;
    propertyName += ":";
    if (propertyName === ":") { //どんなデータ型でも、文字列に変換する機能をJavaScriptが持つことに注意
      return null;
    }
    for (var i=0,tl=this._list,tli=tl.length;i<tli;++i) {
      ti = tl[i];
      tc = ti.cssText;
      if (tc.indexOf(propertyName) > -1) {  //プロパティ名に合致するCSSValueオブジェクトが見つかった場合 
        ti._empercents = tl._fontSize;
        i = tl = tli = tc = prop = propertyName = null;
        return ti;
      }
    }
    if (this._def) {
      i = tl = tli = tc = propertyName = null;
      return (this._def[prop]);
    }
    i = tl = tli = prop = propertyName = null;
    return null;
  },
  /*removePropertyメソッド
   *プロパティを宣言内から除去
   */
/*string*/   removeProperty : function( /*string*/ propertyName) {
    var tg = this.getPropertyCSSValue(propertyName);
    if (tg) {                        //見つかった場合
      this._list.splice(tg._num,1);  //Arrayのspliceを利用して、リストからCSSValueオブジェクトを排除
      --this.length;
    }
  },
  /*getPropertyPriorityメソッド
   *importantなどのpriorityを取得する
   */
/*string*/   getPropertyPriority : function( /*string*/ propertyName) {
    var tg = this.getPropertyCSSValue(propertyName);
    if (tg) {                        //見つかった場合
      return (tg._priority);
    } else {
      return "";
    }
  },
  _isFillStroke : {
    "fill" : 1,
    "stroke" : 1
  },
  _isColor : {
    "color" : 1
  },
  _isStop : {
    "stop-color" : 1
  },
  _isRS : {
    "r" : 1,
    "#" : 1
  },
  /*setPropertyメソッド
   *プロパティを宣言内で、明示的に設定。継承は無視する
   */
/*void*/     setProperty : function( /*string*/ propertyName, /*string*/ value, /*string*/ priority) {
    var cssText = propertyName,
        tg = null,
        ti, paintType, v1,
        uri = null,
        color = null,
        fill, stroke, stop;
    if (!!this[propertyName]) {
      tg = this.getPropertyCSSValue(propertyName);
    }
    cssText += ":";
    cssText += value;
    if (tg) {  //見つかった場合
      tg._priority = priority;
      tg.cssText = cssText;
      ti = tg;
    } else {
      if (this._isFillStroke[propertyName]) {
        /*fill、strokeプロパティは別途、SVGPaintで処理（JavaScriptでは、型キャストを使えないため）
         *CSSPrimitiveValueオブジェクトとSVGPaintオブジェクトを最後に置き換える
         */
        ti = new SVGPaint();
        paintType = /*SVGPaint.SVG_PAINTTYPE_UNKNOWN*/ 0;
        v1 = value.charAt(0);
        if (this._isRS[v1] || ti._keywords[value]) {
          paintType = /*SVGPaint.SVG_PAINTTYPE_RGBCOLOR*/ 1;
          color = value;
        } else if (value === "none") {
          paintType = /*SVGPaint.SVG_PAINTTYPE_NONE*/ 101;
        } else if (this._urlreg.test(value)) {                   //fill属性の値がurl(#id)ならば
          paintType = /*SVGPaint.SVG_PAINTTYPE_URI*/ 107;
          uri = RegExp.$1;
        } else if (value === "currentColor") {
          paintType = /*SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR*/ 102;
          color = this.getPropertyValue("color") || "rgb(0,0,0)";
        }
        ti.setPaint(paintType, uri, color, null);
        paintType = v1 = uri = color = null;
      } else if (this._isStop[propertyName]) {
        ti = new SVGColor();
        if (value === "currentColor") {
          ti.colorType = /*SVGColor.SVG_COLORTYPE_CURRENTCOLOR*/ 3;
          value = this.getPropertyValue("color") || "rgb(0,0,0)";
        } else {
          ti.colorType = /*SVGColor.SVG_COLORTYPE_RGBCOLOR*/ 1;
        }
        ti.setRGBColor(value);
      } else if (this._isColor[propertyName]) {
        ti = new CSSPrimitiveValue();
        fill = this.getPropertyCSSValue("fill");
        stroke = this.getPropertyCSSValue("stroke");
        stop = this.getPropertyCSSValue("stop-color");
        if (fill) {
          if (fill.paintType === /*SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR*/ 102) {
            fill.setPaint(fill.paintType, null, value, null);
          }
        } else if (stroke) {
          if (stroke.paintType === /*SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR*/ 102) {
            stroke.setPaint(fill.paintType, null, value, null);
          }
        } else if (stop) {
          if (stop.colorType === /*SVGColor.SVG_COLORTYPE_CURRENTCOLOR*/ 3) {
            stop.setRGBColor(value);
          }
        }
      } else {
        ti = new CSSPrimitiveValue();
      }
      ti._priority = priority;
      ti.cssText = cssText;
      //_numプロパティはremovePropertyメソッドで利用する
      ti._num = this._list.length;
      this._list[ti._num] = ti;
      this[propertyName] = 1;
      ++this.length;
    }
    if (value === "inherit") {
      ti.cssValueType = CSSValue.CSS_INHERIT;
    } else if (propertyName === "opacity") {
      this._list._opacity = +value;
    } else if (propertyName === "font-size") {
      if (/(%|em)/.test(value)) {
        this._list.fontSize = parseFloat(value);
      }
    }
    cssText = null;
  },
  /*itemメソッド
   *リストの位置にあるプロパティ名を取得する。宣言内のすべてのプロパティ名を取得するのに便利
   */
/*string*/   item : function( /*long*/ index) {
    if (index >= this.length) { //indexの位置にCSSValueが指定されていないとき
      var s = "";
    } else {
      var s = this._list[index].cssText.substring(0, this._list[index].cssText.indexOf(":"));
    }
    return s;
  }
};

function CSSValue() {
  return this;
};
    // UnitTypes
CSSValue.CSS_INHERIT                    = 0;
CSSValue.CSS_PRIMITIVE_VALUE            = 1;
CSSValue.CSS_VALUE_LIST                 = 2;
CSSValue.CSS_CUSTOM                     = 3;
CSSValue.prototype = {
  cssText : "",
  cssValueType : CSSValue.CSS_CUSTOM
};

function CSSPrimitiveValue() {
  return this;
};

CSSPrimitiveValue.CSS_UNKNOWN                    = 0;
CSSPrimitiveValue.CSS_NUMBER                     = 1;
CSSPrimitiveValue.CSS_PERCENTAGE                 = 2;
CSSPrimitiveValue.CSS_EMS                        = 3;
CSSPrimitiveValue.CSS_EXS                        = 4;
CSSPrimitiveValue.CSS_PX                         = 5;
CSSPrimitiveValue.CSS_CM                         = 6;
CSSPrimitiveValue.CSS_MM                         = 7;
CSSPrimitiveValue.CSS_IN                         = 8;
CSSPrimitiveValue.CSS_PT                         = 9;
CSSPrimitiveValue.CSS_PC                         = 10;
CSSPrimitiveValue.CSS_DEG                        = 11;
CSSPrimitiveValue.CSS_RAD                        = 12;
CSSPrimitiveValue.CSS_GRAD                       = 13;
CSSPrimitiveValue.CSS_MS                         = 14;
CSSPrimitiveValue.CSS_S                          = 15;
CSSPrimitiveValue.CSS_HZ                         = 16;
CSSPrimitiveValue.CSS_KHZ                        = 17;
CSSPrimitiveValue.CSS_DIMENSION                  = 18;
CSSPrimitiveValue.CSS_STRING                     = 19;
CSSPrimitiveValue.CSS_URI                        = 20;
CSSPrimitiveValue.CSS_IDENT                      = 21;
CSSPrimitiveValue.CSS_ATTR                       = 22;
CSSPrimitiveValue.CSS_COUNTER                    = 23;
CSSPrimitiveValue.CSS_RECT                       = 24;
CSSPrimitiveValue.CSS_RGBCOLOR                   = 25;
CSSPrimitiveValue.prototype = new CSSValue();
CSSPrimitiveValue.constructor = CSSValue;

(function(){
  this._n = [1, 0.01, 1, 1, 1, 35.43307, 3.543307, 90, 1.25, 15, 1, 180 / Math.PI, 90/100, 1, 1000, 1, 1000, 1]; //CSS_PX単位への変換値（なお、CSS_SはCSS_MSに、CSS_RADとCSS_GRADはCSS_DEGに、CSS_KHZはCSS_HZに統一）
  this.cssValueType = CSSValue.CSS_PRIMITIVE_VALUE;
  this.primitiveType = CSSPrimitiveValue.CSS_UNKNOWN;
  this._value = 1;
  this._percent = 0; //単位に%が使われていた場合、このプロパティの数値を1%として使う
  this._empercent = 0;
  /*void*/ this.setFloatValue = function(/*short*/ unitType, /*float*/ floatValue) {
    if ((/*CSSPrimitiveValue.CSS_UNKNOWN*/ 0 >= unitType) && (unitType >= /*CSSPrimitiveValue.CSS_STRING*/ 19)) { //浮動小数点数単位型をサポートしないCSS単位である場合
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    this.primitiveType = unitType;
    this._value = floatValue * this._n[unitType-1];  //値はあらかじめ、利用しやすいように変換しておく
  };
  /*getFloatValueメソッド
   *別の単位に変換可能。
   */
  this._regD = /\D+$/;
  this._regd = /[\d\.]+/;
  /*float*/ this.getFloatValue = function(/*short*/ unitType) {
    if ((/*CSSPrimitiveValue.CSS_UNKNOWN*/ 0 >= unitType) && (unitType >= /*CSSPrimitiveValue.CSS_STRING*/ 19)) { //浮動小数点数単位型をサポートしないCSS単位である場合
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    var n = this.cssText.match(this._regD),
        type = 0,
        s = +(this.cssText.match(this._regd));
    s = isNaN(s) ? 0 : s;
    if (!!n) {
      n = n[0];
    }
    if (!n) {
      type = /*CSSPrimitiveValue.CSS_NUMBER*/ 1;
    } else if (n === "%") {
      s *= this._percent;
      type = /*CSSPrimitiveValue.CSS_PERCENTAGE*/ 2;
    } else if (n === "em") {
      s *= this._empercent;
      type = /*CSSPrimitiveValue.CSS_EMS*/ 3;
    } else if (n === "ex") {
      type = /*CSSPrimitiveValue.CSS_EXS*/ 4;
    } else if (n === "px") {
      type = /*CSSPrimitiveValue.CSS_PX*/ 5;
    } else if (n === "cm") {
      type = /*CSSPrimitiveValue.CSS_CM*/ 6;
    } else if (n === "mm") {
      type = /*CSSPrimitiveValue.CSS_MM*/ 7;
    } else if (n === "in") {
      type = /*CSSPrimitiveValue.CSS_IN*/ 8;
    } else if (n === "pt") {
      type = /*CSSPrimitiveValue.CSS_PT*/ 9;
    } else if (n === "pc") {
      type = /*CSSPrimitiveValue.CSS_PC*/ 10;
    }
    this._value = s * this._n[type-1];  //値はあらかじめ、利用しやすいように変換しておく
    n = type = s = null;
    return (this._value / this._n[unitType-1]);
  };
  /*void*/ this.setStringValue = function(/*short*/ stringType, /*string*/ stringValue) {
    if (CSSPrimitiveValue.CSS_DIMENSION >= stringType && stringType >= CSSPrimitiveValue.CSS_COUNTER) { //文字列型をサポートしないCSS単位である場合
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    this._value = stringValue;
  };
  /*string*/ this.getStringValue = function(/*short*/ stringType) {
    if (CSSPrimitiveValue.CSS_DIMENSION >= stringType && stringType >= CSSPrimitiveValue.CSS_COUNTER) { //文字列型をサポートしないCSS単位である場合
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    return (this._value);
  };
  /*Counter*/ this.getCounterValue = function() {
    if (this.primitiveType !== CSSPrimitiveValue.CSS_COUNTER) { //Counter型ではないとき
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    return (new Counter());
  };
  /*Rect*/ this.getRectValue = function() {
    if (this.primitiveType !== CSSPrimitiveValue.CSS_RECT) { //Rect型ではないとき
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    return (new Rect());
  };
  /*RGBColor*/ this.getRGBColorValue = function() {
    if (this.primitiveType !== CSSPrimitiveValue.CSS_RGBCOLOR) { //RGBColor型ではないとき
      throw new DOMException(DOMException.INVALID_ACCESS_ERR);
    }
    var s = new RGBColor();
    var rgbColor = this.cssText;
    var tkr = SVGColor.prototype._keywords[rgbColor];
    if (tkr !== void 0) {
      rgbColor = tkr;
    }
    if (rgbColor.indexOf("%", 5) > 0) {      // %を含むrgb形式の場合
      rgbColor = rgbColor.replace(/[\d.]+%/g, function(t) {
        return Math.round((2.55 * parseFloat(t)));
      });
    } else if (rgbColor.indexOf("#") > -1) {  //#を含む場合
      rgbColor = rgbColor.replace(/[\da-f][\da-f]/gi, function(s) {
        return parseInt(s, 16);
      });
    }
    var n = rgbColor.match(/\d+/g);
    s.red.setFloatValue(CSSPrimitiveValue.CSS_NUMBER, parseFloat(n[0]));
    s.green.setFloatValue(CSSPrimitiveValue.CSS_NUMBER, parseFloat(n[1]));
    s.blue.setFloatValue(CSSPrimitiveValue.CSS_NUMBER, parseFloat(n[2]));
    n = rgbColor = null;
    return (s);
  };
}).apply(CSSPrimitiveValue.prototype);
/*CSSValueList
 *Arrayで代用する
 */
function CSSValueList() {
  this.cssValueType = CSSValue.CSS_VALUE_LIST;
  this.length = 0;
  return this;
};
CSSValueList.prototype = new CSSValue();
CSSValueList.constructor = CSSValue;
/*CSSValue*/ CSSValueList.prototype.item = function( /*long*/ index) {
  return (this[index]);
};

function RGBColor() {
  this.red = new CSSPrimitiveValue();
  this.green = new CSSPrimitiveValue();
  this.blue = new CSSPrimitiveValue();
  this.red.primitiveType = this.green.primitiveType = this.blue.primitiveType = /*CSSPrimitiveValue.CSS_NUMBER*/ 1;
  return this;
};

function Rect() {
  this.top = new CSSPrimitiveValue();
  this.right = new CSSPrimitiveValue();
  this.bottom = new CSSPrimitiveValue();
  this.left = new CSSPrimitiveValue();
  return this;
};

function Counter() {
  this.identifier = "";
  this.listStyle = "";
  this.separator = "";
  return this;
};

function ElementCSSInlineStyle() {
  this.style = new CSSStyleDeclaration();
  this._attributeStyle = new CSSStyleDeclaration(); //プレゼンテーション属性の値を格納する
  return this;
};

/*CSS2Properties
 *削除不可
 *さらにSVG CSSを付け加えている
 */
var CSS2Properties = {
  fill : "black",
  stroke : "none",
  cursor : "auto",
  visibility : "visiblee", //visibleが正しいが、初期値を見分ける必要があるため、visibleeとする
  display : "inline-block",
  opacity : "1",
  fillOpacity : "1",
  strokeWidth : "1",
  strokeDasharray : "none",
  strokeDashoffset : "0",
  strokeLinecap : "butt",
  strokeLinejoin : "miter",
  strokeMiterlimit : "4",
  strokeOpacity : "1",
  writingMode : "lr-tb",
  fontFamily : "serif",
  fontSize : "12",
  color : "black",
  fontSizeAdjust : "none",
  fontStretch : "normal",
  fontStyle : "normal",
  fontVariant : "normal",
  fontWeight : "normal",
  font : "inline",

//# Gradient properties:

  stopColor : "black",
  stopOpacity : "1",
  textAnchor : "start",
  azimuth : "center",
                                        // raises(dom::DOMException) on setting
  //簡略プロパティに関しては、初期値を再考せよ
  clip : "auto",
  direction : "ltr",
  letterSpacing : "normal",
  lineHeight : "normal",
  overflow : "visible",
  textAlign : "left",
  textDecoration : "none",
  textIndent : "0",
  textShadow : "none",
  textTransform : "none",
  unicodeBidi : "normal",
  verticalAlign : "baseline",
  whiteSpace : "normal",
  wordSpacing : "normal",
  zIndex : "auto",
//  #

  mask : "none",

//# Filter Effects properties:

  enableBackground : "accumulate",
  filter : "none",
  floodColor : "black",
  floodOpacity : "1",
  lightingColor : "white",

//# Interactivity properties:

  pointerEvents : "visiblePainted",

//# Color and Painting properties:

  colorInterpolation : "sRGB",
  colorInterpolationFilters : "linearRGB",
  colorProfile : "auto",
  colorRendering : "auto",
  imageRendering : "auto",
  marker : "",
  markerEnd : "none",
  markerMid : "none",
  markerStart : "none",
  shapeRendering : "auto",
  textRendering : "auto",

//# Text properties:

  alignmentBaseline : "",
  baselineShift : "baseline",
  dominantBaseline : "auto",
  glyphOrientationHorizontal : "0deg",
  glyphOrientationVertical : "auto",
  kerning : "auto",
  fillRule : "nonzero"
};
CSS2Properties.visibility._n = 1; //初期値の設定（_setPaintで使う）

function CSSStyleSheet() {
/*CSSRule*/      this.ownerRule = null;
/*CSSRuleList*/  this.cssRules = [];
  return this;
};
CSSStyleSheet.prototype = new StyleSheet();
CSSStyleSheet.constructor = StyleSheet;
/*long*/  CSSStyleSheet.prototype.insertRule = function( /*string*/ rule, /*long*/ index) {
  var s = new CSSStyleRule();
  s.parentStyleSheet = this;
  s.cssText = rule;
  this.cssRules.splice(index,s,1);
};
/*void*/  CSSStyleSheet.prototype.deleteRule = function(/*long*/ index) {
  this.cssRules.splice(index, 1);
};


/*getComputedStyle関数
 *最近の計算値を取得する。Document.defaultViewはSafariがグローバル(window)にサポートしていないため付ける。
 */
/*interface ViewCSS : views::AbstractView {*/
Document.prototype.defaultView = new ViewCSS();
function ViewCSS(){
  return this;
};
/*CSSStyleDeclaration*/ ViewCSS.prototype.getComputedStyle = function( /*Element*/ elt, /*string*/ pseudoElt) {
  if (!!elt._currentStyle) {
    /*キャッシュがあれば、それを返す*/
    return (elt._currentStyle);
  }
  var s = new CSSStyleDeclaration();
  elt._currentStyle = s;
  //リストを連結することによって、カスケーディングを実現する
  var pelt = elt.parentNode;
  if (pelt) {
    var p = this.getComputedStyle(pelt, pseudoElt)._list;
  } else {
    var p = {length:0, _opacity:1, _fontSize:12};
  }
  var q = s._list;
  if (!!elt.style) {
    var estl = elt.style._list, easl = elt._attributeStyle._list, csi = CSSValue.CSS_INHERIT;
    for (var i=0,eli=estl.length;i<eli;++i) {
      q[q.length] = estl[i];
    }
    for (var i=0,eli=easl.length;i<eli;++i) {
      q[q.length] = easl[i];   //プレゼンテーション属性を結びつける
    }
    estl = easl = null;
    for (var i=0,qli=q.length;i<qli;++i) {
      if (q[i].cssValueType === csi) {
        q.splice(i, 1);
        --qli;
      }
    }
  }
  for (var i=0,pli=p.length;i<pli;++i) {
    q[q.length] = p[i];
  }
  if (elt._runtimeStyle) {
    q = elt._runtimeStyle._list.concat(q);
  }
  s._def = this._defaultCSS;    //デフォルト値の設定
  s._list =  q;
  if (!!elt.style) {
    var eso = elt.style._list._opacity || elt._attributeStyle._list._opacity;
  } else {
    var eso = 1;
  }
  s._list._opacity = p._opacity * (eso || 1);
  s._list._fontSize = p._fontSize;
  pelt = eso = p = q = null;
  s._document = elt.ownerDocument;
  return s;
};

/*getOverrideStyleメソッド
 *指定した要素の上書きスタイルシートを取得。
 */
/*function DocumentCSS : stylesheets::DocumentStyle {*/
/*CSSStyleDeclaration*/ Document.prototype.getOverrideStyle = function( /*Element*/ elt, /*string*/ pseudoElt) {
  var tar = elt;
  if (!!tar._runtimeStyle) {
    return (tar._runtimeStyle);
  } else {
    var s = new CSSStyleDeclaration(), setProp = s.setProperty;
    tar._runtimeStyle = s;
  }
  s.setProperty = function(propertyName, value, priority) {
    setProp.call(s, propertyName, value, priority);
    var tar = elt, el = tar._tar, isFill = isStroke = false;
    delete tar._currentStyle;
    if ((tar.localName === "g") || (tar.localName === "a")) {
      var sl = tar.getElementsByTagNameNS("http://www.w3.org/2000/svg", "*");
      if (sl) {
        for (var i=0,sli=sl.length;i<sli;++i) {
          var di = sl[i];
          delete di._currentStyle;
          NAIBU._setPaint(di, di.getScreenCTM());
          di = null;
        }
        sl = null;
      }
      el = null;
    }
    if (!el) {
      return;
    }
    NAIBU._setPaint(tar, tar.getScreenCTM());
    el = tar = value = null;
  }
  return s;
};
/*createCSSStyleSheetメソッド
 *文書のスタイルシートを作成
 */
/*interface DOMImplementationCSS : DOMImplementation {*/
/*CSSStyleSheet*/ DOMImplementation.createCSSStyleSheet = function( /*string*/ title, /*string*/ media) {
  var s = new CSSStyleSheet();
  s.title = title;
  var nm = new MediaList();
  nm.mediaText = media;
  if (media !== "") {
    var mes = media.split(",");  //文字列をコンマで区切って配列に
    for (var i=0,mli=mes.length;i<mli;++i) {
      nm.appendMedium(mes[i]);   //メディアリストに値を加えていく
    }
  }
  s.media = nm;
  return s;
};
/*
#endif // _CSS_IDL_
*/