/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.sugina.util;

import java.io.IOException;

import shohaku.core.helpers.HCoder;
import shohaku.core.lang.ValueOf;
import shohaku.core.util.XProperties;

/**
 * プロパティ値を、基礎的なデータ型のグラフ構造として解析する拡張プロパティセットを提供します。<br>
 * プロパティ値に、数値や文字、文字列、日付を定義できます、またマップやリスト、セットを入れ子上に定義することができます。<br>
 * このプロパティセットは、shohaku.core.lang.ValueOf を使用して値のエンコードとデコードを行います。<br>
 * 書式規則の詳細は、shohaku.core.lang.ValueOf を参照してください。
 */
public class ValueOfXProperties extends XProperties {

    /** serialVersionUID */
    private static final long serialVersionUID = 9104270482719471355L;

    /**
     * 初期化します。
     */
    public ValueOfXProperties() {
        super();
    }

    protected void putProperty(String key, String value, boolean isEscapes) throws IOException {
        String k = key;
        String v = value;
        if (isEscapes) {
            k = HCoder.decodePropertiesEscapes(k);
            v = HCoder.decodePropertiesEscapes(v);
        }
        try {
            this.lookup.put(k, ValueOf.decode(v));
        } catch (IllegalArgumentException e) {
            final IOException ie = new IOException("ValueOf decode err.");
            ie.initCause(e);// 1.5以降は起因例外のコンストラクタがある
            throw ie;
        }
    }

    protected void storeProperty(StringBuffer buf, Object key, Object value, boolean isEscapes) throws IOException {
        String k = String.valueOf(key);
        String v = ValueOf.encode(value);
        if (isEscapes) {
            k = HCoder.encodePropertiesEscapes(k);
            v = HCoder.encodePropertiesEscapes(v);
        } else {
            k = appendEscapeChar(k);
        }
        buf.append(k);
        buf.append('=');
        buf.append(v);
    }

}
