/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.sugina.dynbind;

/**
 * 更新規則と名前で拘束された引数情報のリストを格納する機能を提供します。
 */
public class BindArgumentsDesc {

    /* 引数情報。 */
    private final BindArgumentDesc[] arguments;

    /**
     * デフォルトコンストラクタ。
     */
    public BindArgumentsDesc() {
        this(new BindArgumentDesc[0]);
    }

    /**
     * 引数情報の配列を指定して初期化します。
     * 
     * @param args
     *            引数の情報
     */
    public BindArgumentsDesc(BindArgumentDesc[] args) {
        if (args == null) {
            throw new NullPointerException("argument is null.");
        }
        this.arguments = (BindArgumentDesc[]) args.clone();
    }

    /*
     * Property
     */

    /**
     * 引数の値を返却します。
     * 
     * @return 引数の値
     */
    public Object[] getArgumentValues() {
        BindArgumentDesc[] args = arguments;
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; i++) {
            values[i] = args[i].getValue();
        }
        return values;
    }

    /**
     * 引数の型を返却します。
     * 
     * @return 引数の型
     */
    public Class[] getArgumentTypes() {
        BindArgumentDesc[] args = arguments;
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; i++) {
            types[i] = args[i].getType();
        }
        return types;
    }

    /**
     * 引数拘束名を返却します。
     * 
     * @return 引数拘束名
     */
    public String[] getArgumentNames() {
        BindArgumentDesc[] args = arguments;
        String[] names = new String[args.length];
        for (int i = 0; i < args.length; i++) {
            names[i] = args[i].getBindName();
        }
        return names;
    }

    /**
     * 引数の拘束ルールを返却します。
     * 
     * @return 引数の拘束ルール
     */
    public BindArgumentRule[] getArgumentRules() {
        BindArgumentDesc[] args = arguments;
        BindArgumentRule[] rules = new BindArgumentRule[args.length];
        for (int i = 0; i < args.length; i++) {
            rules[i] = args[i].getBindRule();
        }
        return rules;
    }

    /**
     * 引数情報の配列を返却します。
     * 
     * @return 引数情報の配列
     */
    public BindArgumentDesc[] getArguments() {
        return (BindArgumentDesc[]) arguments.clone();
    }
}
