/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.sugina.dynbind;

/**
 * 引数の拘束規則の定義を提供します。
 */
public final class BindArgumentRule {

    /** 引数拘束規則：固定の値。 */
    public static final BindArgumentRule FINAL = new BindArgumentRule(0, "bind rule fanal.");

    /** 引数拘束規則：上書き可能な値。 */
    public static final BindArgumentRule OVERWRITE = new BindArgumentRule(1, "bind rule overwrite.");

    /** 引数拘束規則：実行時に指定。 */
    public static final BindArgumentRule REQUIRED = new BindArgumentRule(2, "bind rule required.");

    /* ルールの識別子 */
    private final int identifier;

    /* ルールの概要 */
    private final String description;

    /**
     * ルールの識別子と概要を格納して初期化します。
     * 
     * @param id
     *            ルールの識別子
     * @param desc
     *            ルールの概要
     */
    private BindArgumentRule(int id, String desc) {
        this.identifier = id;
        this.description = desc;
    }

    /**
     * ルールの識別子を返却します。
     * 
     * @return ルールの識別子
     */
    public int getIdentifier() {
        return identifier;
    }

    /**
     * ルールの識別子と概要を id(description) の書式で返却します。
     * 
     * @return 文字列表現
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return identifier + "(" + description + ")";
    }

}
