(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(**************)
(* ܥ *)
(**************)

module Vertex : sig

  type t = {pos : int; state : int}

  (* üpos,state=-1ɽȤˤ*)
  val terminal : t

  val create : pos:int -> state:int -> t

  val compare : t -> t -> int
  val equal : t -> t -> bool
  val hash : t -> int
end

module EdgeLabel : sig

  (* cost = ǼΤΥ + ξ֤ؤϢܥ *)
  type t = {mrph : Mrph.mrph; pos : int; cost : int}

  val create : Mrph.mrph -> pos:int -> cost:int -> t
  val compare : t -> t -> int
  val equal : t -> t -> bool
end

module Edge : sig
    type t

    val create : Vertex.t -> EdgeLabel.t -> Vertex.t -> t
    val label : t -> EdgeLabel.t
    val src : t -> Vertex.t
    val dst : t -> Vertex.t
  end

module Graph : sig 
  type t

  (* [create length] 0...length-1ΰ֤ǽ*) 
  val create : int -> t
  val length : t -> int

  val add_vertex : t -> Vertex.t -> unit
  val mem_vertex : t -> Vertex.t -> bool
  val add_edge : t -> Edge.t -> unit

  (* ĺãǽʼĺؤ *)
  val succ_e : t -> Vertex.t -> Edge.t list
  val pred_e : t -> Vertex.t -> Edge.t list

  (* [iter_pos f g pos] gposˤĺ٤ƤfŬѤ롣*)
  val iter_pos : (Vertex.t -> unit) -> t -> int -> unit

end

module Mark : sig
  type 'a t

  val create : unit -> 'a t
  val lookup : 'a t -> Vertex.t -> 'a option
  val mark : 'a t -> Vertex.t -> 'a -> unit
end

module type CostType = sig
  type t
  val weight : EdgeLabel.t -> t
  val zero : t
  val add : t -> t -> t
  val compare : t -> t -> int
end

module Viterbi : functor (Cost : CostType) -> sig
  type cost
  type marker = Cost.t * (Edge.t option)

  val mark_pos : Graph.t -> marker Mark.t -> int -> unit

  val forward_cost : Graph.t -> Vertex.t -> marker Mark.t

 (* ĤʤNot foundꤲ *)
  val best_path : (Graph.t * marker Mark.t) -> Vertex.t -> int -> 
    (Edge.t * cost) list

end with type cost = Cost.t
