/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* $Id: mrph.c 132 2005-08-07 18:05:59Z yori $ */

#include <string.h>
/*#include <stdio.h> */
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include "chalib.h"
#include "dartsdic.h"
#include "tools.h"

value mrph_posid (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->posid));
}

value mrph_inf_type (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->inf_type));
}

value mrph_inf_form (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->inf_form));
}

value mrph_weight (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->weight));
}

value mrph_con_tbl (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->con_tbl));
}

value mrph_dat_index (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->dat_index));
}

value mrph_keyword (value mrph){
  CAMLparam1 (mrph);
  CAMLlocal1 (string);

  string = alloc_string(((mrph_t*)mrph)->keyword_len);
  memcpy(String_val(string), 
	 ((mrph_t*)mrph)->keyword, 
	 ((mrph_t*)mrph)->keyword_len*sizeof(char));

  CAMLreturn (string);
}

value mrph_keyword_len (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->keyword_len));
}

value mrph_is_undef (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn (Val_long(((mrph_t*)mrph)->is_undef));
}

value mrph_darts (value mrph){
  CAMLparam1 (mrph);
  CAMLreturn ((value)((mrph_t*)mrph)->darts);
}

value mrph_headword (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLlocal1 (string);

  string = alloc_string(((mrph_t*)mrph_data)->headword_len);
  memcpy(String_val(string), 
	 ((mrph_t*)mrph_data)->headword, 
	 ((mrph_t*)mrph_data)->headword_len*sizeof(char));

  CAMLreturn (string);
}

value mrph_headword_len (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_t*)mrph_data)->headword_len));
}

CAMLprim value new_mrph_opt (value posid, 
			     value inf_type, 
			     value inf_form,
			     value weight,
			     value con_tbl,
			     value dat_index,
			     value keyword,
			     value headword,
			     value is_undef,
			     value darts){
  mrph_t *mrph;

  mrph = (mrph_t*)malloc(sizeof(mrph_t));
  
  mrph->posid = Long_val(posid);
  mrph->inf_type = Long_val(inf_type);
  mrph->inf_form = Long_val(inf_form);
  mrph->weight = Long_val(weight);
  mrph->con_tbl = Long_val(con_tbl);
  mrph->dat_index = Long_val(dat_index);

  mrph->keyword_len = string_length(keyword);
  mrph->keyword = copy_new_string(String_val(keyword),
				  mrph->keyword_len);

  mrph->is_undef = Long_val(is_undef);
  mrph->darts = (darts_t*)darts;

  mrph->headword_len = string_length(headword);
  mrph->headword = copy_new_string(String_val(headword),
				   mrph->headword_len);

  return ((value)mrph);
}
    
CAMLprim value new_mrph_byte (value *argv, int argn){
  return new_mrph_opt(argv[0], argv[1], argv[2], argv[3], argv[4],
		      argv[5], argv[6], argv[7], argv[8], argv[9]);
}

value delete_mrph (value mrph){
  CAMLparam1 (mrph);
  /*  printf("delete_mrph %d\n", mrph); */
  free(((mrph_t*)mrph)->keyword);
  free((mrph_t*)mrph);
  CAMLreturn (Val_unit);
}

value mrph_default_weight (value unit){
  CAMLparam1(unit);
  CAMLreturn(Val_long(MRPH_DEFAULT_WEIGHT));
}

value mrph_cost_weight (value unit){
  CAMLparam1(unit);
  CAMLreturn(Val_long(Cha_mrph_cost_weight));
}

value connect_cost (value v1, value v2){
  CAMLparam2(v1, v2);
  CAMLlocal1(ret);
  int state;
  mrph_t *lex;
  int con_cost;
  int new_state;

  state = Long_val(v1);
  lex = (mrph_t *)v2;

  new_state = cha_check_automaton
    (state, lex->con_tbl, Cha_con_cost_undef, &con_cost);

  ret = alloc_tuple(2);
  Store_field(ret, 0, Val_long(new_state));
  Store_field(ret, 1, Val_long(con_cost));

  CAMLreturn (ret);
}
