/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004  Yamagata Yoriyuki                           */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* $Id: undef_info.c 39 2004-11-14 19:58:01Z yori $ */

#include <string.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include "chalib.h"
#include "dartsdic.h"

value undef_info_cost (value info){
  CAMLparam1(info);
  CAMLreturn (Val_long(((undef_info*)info)->cost));
}

value undef_info_cost_step (value info){
  CAMLparam1(info);
  CAMLreturn (Val_long(((undef_info*)info)->cost_step));
}

value undef_info_con_tbl (value info){
  CAMLparam1(info);
  CAMLreturn (Val_long(((undef_info*)info)->con_tbl));
}

value undef_info_hinsi (value info){
  CAMLparam1(info);
  CAMLreturn (Val_long(((undef_info*)info)->hinsi));
}

value get_undef_info (value no){
  CAMLparam1(no);
  CAMLreturn ((value)&Cha_undef_info[Long_val(no)-1]);
}

value undef_hinsi_max (value unit){
  CAMLparam1(unit);
  CAMLreturn(Val_long(UNDEF_HINSI_MAX));
}

value undef_info_num (value unit){
  CAMLparam1(unit);
  CAMLreturn(Val_long(Cha_undef_info_num));
}
