(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004  Yamagata Yoriyuki                           *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

let count s ~byte1 ~byte2 =
  let rec f b a =
    if byte2 <= b then a else
    let c = Char.code s.[b] in
    if c < 0x80 then f (b+1) (a+1) else
    if c = 0x8f then f (b+3) (a+1) else
    f (b+2) (a+1) in
  let r = f byte1 0 in
(*  Printf.printf "EucString.count: string=%s, byte1=%d, byte2=%d, result=%d\n"
    s byte1 byte2 r;			(*debug*)*)
  r

let length s = count s 0 (String.length s)

let next s ~byte =
  let c = Char.code s.[byte] in
  if c < 0x80 then byte+1 else
  if c = 0x8f then byte+3 else
  byte+2

let rec nth string ~byte ~count =
  if count <= 0 then byte else
  nth string ~byte:(next string byte) ~count:(count - 1)

let sub string ~pos ~len =
  let p = nth string ~byte:0 ~count:pos in
  String.sub string p (nth string ~byte:p ~count:len - p)
      
