/*
HMScrollableMatrix.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMScrollableMatrix.h"

@interface HMMatrix : NSMatrix
@end

@implementation HMMatrix

- (void)drawCellAtRow:(int)row column:(int)column
{
    [super drawCellAtRow:row column:column];
}

@end

@interface HMScrollableMatrix (private)

// Matrix management
- (void)_updateMatrix;

@end

@implementation HMScrollableMatrix

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)_init
{
    // Get bounds
    NSRect  bounds;
    bounds = [self bounds];
    
    // Create scroll view
    _scrollView = [[NSScrollView alloc] initWithFrame:bounds];
    [_scrollView setHasHorizontalScroller:NO];
    [_scrollView setHasVerticalScroller:YES];
    [_scrollView setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];
    
    [self addSubview:_scrollView];
    [_scrollView release];
    
    // Create matrix
    _matrix = [[HMMatrix alloc] initWithFrame:NSZeroRect];
    
    [_scrollView setDocumentView:_matrix];
    [_matrix release];
}

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Common init
    [self _init];
    
    return self;
}

- (id)initWithCoder:(NSCoder*)coder
{
    self = [super initWithCoder:coder];
    if (!self) {
        return nil;
    }
    
    // Common init
    [self _init];
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- Cell atribute --
//--------------------------------------------------------------//

- (int)numberOfCells
{
    return _numberOfCells;
}

- (void)setNumberOfCells:(int)numberOfCells
{
    _numberOfCells = numberOfCells;
}

- (NSSize)cellSize
{
    return _cellSize;
}

- (void)setCellSize:(NSSize)cellSize
{
    _cellSize = cellSize;
}

- (void)sizeToCells
{
    [self _updateMatrix];
}

//--------------------------------------------------------------//
#pragma mark -- Accessors --
//--------------------------------------------------------------//

- (NSScrollView*)scrollView
{
    return _scrollView;
}

- (NSMatrix*)matrix
{
    return _matrix;
}

//--------------------------------------------------------------//
#pragma mark -- Matrix management --
//--------------------------------------------------------------//

- (void)setFrame:(NSRect)frame
{
    NSRect  oldFrame;
    oldFrame = [self frame];
    [super setFrame:frame];
    
    // Update matrix
    if (!NSEqualRects(frame, oldFrame)) {
        [self _updateMatrix];
    }
}

- (void)_updateMatrix
{
    // Get visibile rect of scroll view
    NSRect  visibleRect;
    visibleRect = [_scrollView documentVisibleRect];
    
    // Decide rows and columns number
    int columns, rows;
    columns = visibleRect.size.width / _cellSize.width;
    if (columns == 0) {
        columns = 1;
    }
    rows = _numberOfCells / columns;
    
    //NSSize  interCell;
    //interCell = [_matrix intercellSpacing];
    
    // Renew rows and columns
    [_matrix renewRows:rows columns:columns];
    [_matrix sizeToCells];
}

@end
