/*
 * Created on 08-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.tg.old;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TGWriter {

    public static void writeSong(String fileName, Song song) {
        File file = new File(fileName);
        Document doc = createDocument();
        writeSong(doc, file, song);
    }


    
    
    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } 
        return document;
    }        
    
    
    public static void writeSong(Document document,File file, Song song) {
        clearDocument(document);
        createSongNode(document, document, song);
        saveDocument(document,file);
    }

    public static void createSongNode(Document document, Node parent, Song song) {
        Node node = document.createElement(TGFormat.MODEL_SONG);
        parent.appendChild(node);

        Iterator it = song.getTracks().iterator();
        while (it.hasNext()) {
            SongTrack track = (SongTrack) it.next();
            createTrackNode(document, node, track);
        }

        createTextNode(document, node, TGFormat.PARAM_NAME, song.getName());
    }

    public static void createTrackNode(Document document, Node parent, SongTrack track) {
        Node node = document.createElement(TGFormat.MODEL_TRACK);
        parent.appendChild(node);

        Iterator measureIt = track.getMeasures().iterator();
        while (measureIt.hasNext()) {
            Measure measure = (Measure) measureIt.next();
            createMeasureNode(document, node, measure);
        }

        Iterator stringIt = track.getStrings().iterator();
        while (stringIt.hasNext()) {
            InstrumentString string = (InstrumentString) stringIt.next();
            createInstrumentStringNode(document, node, string);
        }

        createTextNode(document, node,TGFormat.PARAM_CHANNEL, Integer.toString(track.getChannel()));
        createTextNode(document, node,TGFormat.PARAM_INSTRUMENT, Integer.toString(track.getInstrument()));
    }

    public static void createMeasureNode(Document document, Node parent, Measure measure) {
        Node node = document.createElement(TGFormat.MODEL_MEASURE);
        parent.appendChild(node);

        Iterator noteIt = measure.getNotes().iterator();
        while (noteIt.hasNext()) {
            Note note = (Note) noteIt.next();
            createNoteNode(document, node, note);
        }

        Iterator silenceIt = measure.getSilences().iterator();
        while (silenceIt.hasNext()) {
            Silence silence = (Silence) silenceIt.next();
            createSilenceNode(document, node, silence);
        }

        createTextNode(document, node,TGFormat.PARAM_START, Long.toString(measure.getStart()));
        createTextNode(document, node,TGFormat.PARAM_REPEATSTART, Boolean.toString(measure.isRepeatStart()));
        createTextNode(document, node,TGFormat.PARAM_NUMBEROFREPETITIONS, Integer.toString(measure.getNumberOfRepetitions()));

        createTimeSignatureNode(document, node, measure.getTimeSignature());
        createTempo(document, node, measure.getTempo());
    }

    public static void createNoteNode(Document document, Node parent, Note note) {
        Node node = document.createElement(TGFormat.MODEL_NOTE);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_START, Long.toString(note.getStart()));
        createTextNode(document, node,TGFormat.PARAM_VALUE, Integer.toString(note.getValue()));
        createTextNode(document, node,TGFormat.PARAM_VELOCITY, Integer.toString(note.getVelocity()));
        createTextNode(document, node,TGFormat.PARAM_TIEDNOTE, Boolean.toString(note.isTiedNote()));
        
        createDurationNode(document, node, note.getDuration());
        //createInstrumentStringNode(document, node, note.getString());
    }

    public static void createSilenceNode(Document document, Node parent, Silence silence) {
        Node node = document.createElement(TGFormat.MODEL_SILENCE);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_START, Long.toString(silence.getStart()));
        createDurationNode(document, node, silence.getDuration());
    }

    public static void createTimeSignatureNode(Document document, Node parent, TimeSignature timeSignature) {
        Node node = document.createElement(TGFormat.MODEL_TIMESIGNATURE);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_NUMERATOR, Integer.toString(timeSignature.getNumerator()));
        createDurationNode(document, node, timeSignature.getDenominator());
    }

    public static void createTempo(Document document, Node parent, Tempo tempo) {
        Node node = document.createElement(TGFormat.MODEL_TEMPO);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_VALUE, Integer.toString(tempo.getValue()));
    }

    public static void createDurationNode(Document document, Node parent, Duration duration) {
        Node node = document.createElement(TGFormat.MODEL_DURATION);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_VALUE, Integer.toString(duration.getValue()));
        createTextNode(document, node,TGFormat.PARAM_DOTTED, Boolean.toString(duration.isDotted()));

        createTupletoNode(document, node, duration.getTupleto());
    }

    public static void createInstrumentStringNode(Document document, Node parent, InstrumentString instrumentString) {
        Node node = document.createElement(TGFormat.MODEL_INSTRUMENTSTRING);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_NUMBER, Integer.toString(instrumentString.getNumber()));
        createTextNode(document, node,TGFormat.PARAM_VALUE, Integer.toString(instrumentString.getValue()));
    }

    public static void createTupletoNode(Document document, Node parent, Tupleto tupleto) {
        Node node = document.createElement(TGFormat.MODEL_TUPLETO);
        parent.appendChild(node);

        createTextNode(document, node,TGFormat.PARAM_ENTERS, Integer.toString(tupleto.getEnters()));
        createTextNode(document, node,TGFormat.PARAM_TIMES, Integer.toString(tupleto.getTimes()));
    }

    private static void createTextNode(Document document, Node parent, String key, String value) {
        Node node = document.createElement(key);
        node.appendChild(document.createTextNode(value));
        parent.appendChild(node);
    }

    public static void clearDocument(Document document) {
        Node node = document.getFirstChild();
        if (node != null) {
            document.removeChild(node);
        }
    }

    public static void saveDocument(Document document,File file) {
        try {
            FileOutputStream fs = new FileOutputStream(file);

            // Write it out again
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            Source input = new DOMSource(document);
            Result output = new StreamResult(fs);
            idTransform.transform(input, output);

        } catch (FactoryConfigurationError e) {
            e.printStackTrace();
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }
}