/*
 * Created on 08-ago-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.undo;

import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class UndoableEdit {
    private static final int UNDO_ACTION = 1;
    private static final int REDO_ACTION = 2;
    private TablatureEditor tablatureEditor;
    private Song beforeEdit;
    private Song afterEdit;
    private int doAction;

    public UndoableEdit(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
        this.doAction = UNDO_ACTION;
    }

    public void setBeforeEdit(Song beforeEdit) {
        this.beforeEdit = beforeEdit;
    }

    public void setAfterEdit(Song afterEdit) {
        this.afterEdit = afterEdit;
    }

    public void redo() throws CannotRedoException {
        if (canRedo()) {
            this.replace(afterEdit);
            this.doAction = UNDO_ACTION;
        }
    }

    public void undo() throws CannotUndoException {
        if (canUndo()) {
            this.replace(beforeEdit);
            this.doAction = REDO_ACTION;
        }

    }

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }

    private void replace(Song song) {
        tablatureEditor.getSongManager().setSong(song);
        tablatureEditor.getTablature().updateTablature();
        tablatureEditor.getTablature().redraw();
    }

}