/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.Test;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongCoords {
    private static final int DEFAULT_FIRST_TRACK_SPAN = 50;
    private static final int DEFAULT_TRACK_SPAN = 150;
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;
    private int width;
    private int height;
    private List quarterSpanHelpers;
    
    public SongCoords(Tablature tablature,SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }	

    public void init(){
        this.tracksCoords = new ArrayList();
        this.quarterSpanHelpers = new ArrayList();
    }    

    public void createTracks() {
        this.tracksCoords.clear();  
        this.quarterSpanHelpers.clear();       
        for (int trackIdx = 0; trackIdx < this.songManager.getSong().getTracks().size(); trackIdx++) {
            SongTrack track = (SongTrack) this.songManager.getSong().getTracks().get(trackIdx);
            SongTrackCoords trackCoords = new SongTrackCoords(this.tablature,this.songManager, track);
            trackCoords.createMeasures();
            this.tracksCoords.add(trackCoords);            
        }
    }    
    
    public void updateTracks() {
        this.width = 0;
        this.height = 0;
        int maxWidth = 0;

        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)tracksCoords.get(trackIdx);
            trackCoords.updateMeasures();
            if(trackCoords.getWidth() > maxWidth){
                maxWidth = trackCoords.getWidth();
            }
            this.height += trackCoords.getHeight() + DEFAULT_TRACK_SPAN;
           
        }
        this.width = maxWidth;
        
        this.updateRepetitions();
    }
    
    
    public void fireUpdate(int measureId,boolean isNew){
        int maxWidth = 0;
        QuarterSpanHelper quarterSpan = null;
        if(getQuarterSpans().size() > measureId){                                
            quarterSpan = tablature.getSongCoords().getQuarterSpan(measureId);
            quarterSpan.reset();
        }else{
            quarterSpan = new QuarterSpanHelper();
            tablature.getSongCoords().getQuarterSpans().add(quarterSpan);
        }         
        
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)tracksCoords.get(trackIdx);
            trackCoords.fireChanges(measureId,quarterSpan,isNew);   
        } 
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)tracksCoords.get(trackIdx);
            trackCoords.fireUpdate(measureId,quarterSpan);
            if(trackCoords.getWidth() > maxWidth){
                maxWidth = trackCoords.getWidth();
            }            
        }            
        this.width = maxWidth;
    }
    
    public void updateRepetitions(){
        this.songManager.calculateMeasureStartWidthRepetitions();
    }
    
    public void paintTracks(GC gc,Rectangle clientArea,int fromX,int fromY) {               
        int posY = fromY + DEFAULT_FIRST_TRACK_SPAN;
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);
            
            trackCoords.paintTrack(gc,fromX, posY,clientArea);            
            posY += DEFAULT_TRACK_SPAN;
        }                  
    }


    public SongTrackCoords getTrackAt(int y,int vScroll){
        SongTrackCoords trackCoords = null;
        int posY = DEFAULT_FIRST_TRACK_SPAN + vScroll;        
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            int trackWidth = track.getWidth();
            int trackHeight = track.getHeight();
            if(y >= posY && y <= posY + trackHeight){
                trackCoords = track;
            }            
            posY += DEFAULT_TRACK_SPAN;
        }     
        return trackCoords;
    }
    
    public SongTrackCoords getNextTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int nextIndex = trackIdx + 1;
                if(nextIndex < this.tracksCoords.size()){
                    track = (SongTrackCoords)this.tracksCoords.get(nextIndex);                    
                }
                break;
            }
        }     
        return track;
    }
    
    public SongTrackCoords getPrevTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int prevIndex = trackIdx - 1;
                if(prevIndex >= 0){
                    track = (SongTrackCoords)this.tracksCoords.get(prevIndex);                    
                }
                break;
            }
        }     
        return track;
    }    

    public SongTrackCoords getTrack(SongTrack songTrack){
        SongTrackCoords trackCoords = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.getTrack().equals(songTrack)){
                trackCoords = currTrack;
                break;
            }
        }     
        return trackCoords;
    }        
    
    
    public SongTrackCoords getFirstTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return track;
    }       

    public SongTrackCoords getLastTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return track;
    }               
     
    private SongTrack makeNewTrack(SongTrack songTrack){        
        //measures
        List measures = new ArrayList();        
        Iterator measureIt = songTrack.getMeasures().iterator();
        while(measureIt.hasNext()){
            Measure measure = (Measure)measureIt.next();
            
            long start = measure.getStart();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            
            measures.add(new Measure(start,new ArrayList(),new ArrayList(),timeSignature,tempo,repeatStart,nombreOfRepetitions));
        }
        //Strings
        List strings = SongManager.createDefaultInstrumentStrings();
        int channel = getSongManager().getFreeChannel(0,false);
        return new SongTrack(channel,0,measures,strings);
    }
    
    public void createTrack(){
        SongTrack track = null;
        if(this.songManager.getSong().getTracks().isEmpty()){
            track = Test.getDefaultTrack();
        }else{
            track = makeNewTrack(getFirstTrack().getTrack());
        }
        addTrack(track);
    }
    
    public void addTrack(SongTrack track){
        this.songManager.getSong().getTracks().add(track);
    }

    public void removeTrack(SongTrackCoords track){
        removeTrack(track.getTrack());
    }

    public void removeTrack(SongTrack track){
        this.songManager.getSong().getTracks().remove(track);
    }
    
    
    public void changeTimeSignature(long start,TimeSignature timeSignature,boolean toEnd){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeTimeSignature(start,timeSignature,toEnd);
        }
    }
    
    public void changeTempo(long start,Tempo tempo,boolean toEnd){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeTempo(start,tempo,toEnd);
        }
    }    

    
    public void changeOpenRepeat(long start){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeOpenRepeat(start);
        }
        updateRepetitions();
    }        
    
    public void changeCloseRepeat(long start,int numberOfRepetitions){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeCloseRepeat(start,numberOfRepetitions);
        }
        updateRepetitions();
    }         

    public void addNewMeasureBeforeEnd(){        
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.addNewMeasureBeforeEnd();
        }                
    }

    public void removeMeasure(long start){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.removeMeasure(start);
        }        
    }
        
    
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public List getTrackCoords(){
        return this.tracksCoords;
    }
    
    public int getWidth(){
        return this.width;
    }
    
    public int getHeight(){
        return this.height;
    }    
    
    public List getQuarterSpans(){
        return this.quarterSpanHelpers;
    }
    
    public QuarterSpanHelper getQuarterSpan(int i){
        return (QuarterSpanHelper)this.quarterSpanHelpers.get(i);
    }    

    public void addQuarterSpan(QuarterSpanHelper quarterSpan){
        this.quarterSpanHelpers.add(quarterSpan);
    }    
    
    
}