/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureCoords {
    /**
     * Espacio por defecto a la izquierda
     */
    public static final int DEFAULT_LEFT_SPAN = 15;
    /**
     * Espacio por defecto a la derecha
     */
    public static final int DEFAULT_RIGHT_SPAN = 15;    
    /**
     * Espacio por defecto del timeSignature
     */
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;    
    /**
     * Espacio por defecto entre negra y negra
     */
    public static final int DEFAULT_QUARTER_SPAN = 30;
    /**
     * Widget de la tablatura
     */    
    private Tablature tablature;
    /**
     * ID del measure en el Track
     */
    private int measureId;    
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /** 
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Ultima Posicion X
     */
    private int lastFromX;
    /**
     * Ultima Posicion Y
     */
    private int lastFromY;
    /**
     * Ancho del Compas
     */
    private int width;
    /**
     * Alto del Compas
     */
    private int height;
    /**
     * Espacio entre negras
     */
    private int quarterSpan;
    /**
     * Espacio entre pulsos
     */        
    private long beatLength;
    /**
     * Boolean para saber si hay que pintar el TimeSignature
     */
    private boolean paintTimeSignature;
    /**
     * Boolean para saber si hay que pintar el Tempo
     */
    private boolean paintTempo;    
    /**
     * Coordenadas de notas
     */
    private List measureComponents;
    /**
     * Compas de Referencia
     */
    private Measure measure;
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;
    /**
     * Tema de Referencia
     */
    private SongManager songManager;
    /**
     * El caret para editar la tablatura
     */
    private Caret caret;   

    public MeasureCoords(int measureId,SongManager songManager,Tablature tablature, Measure measure, SongTrackCoords trackCoords) {
        this.measureId = measureId;
        this.measure = measure;
        this.trackCoords = trackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    
    /**
     * Crea los valores necesarios
     */
    public void create() {        
        this.measureComponents.clear();
        this.beatLength =  TablatureUtil.getBeatLength(getMeasure().getTimeSignature());
        autoCompleteSilences();        
        calculateQuarterSpan();
    }    
    
    
    /**
     * Actualiza los valores para dibujar
     */
    public void update() {        
        orderNotes();
        calculateTimeSignature();
        calculateTempo();
        calculateWidth();
        calculateHeight();
        calcuateComponents();        
        updateComponents();        
        updateCaret();
    }

    /**
     * Calcula el espacio que debe haber entre negras
     */
    private void calculateQuarterSpan() {        
        if (measure.getNotes().isEmpty() && measure.getSilences().isEmpty()) {
            this.quarterSpan = DEFAULT_QUARTER_SPAN;
        } else {
            Duration minDuration = null;
            if(!measure.getNotes().isEmpty()){
                Note minNote = null;
                for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
                    Note currentNote = (Note) measure.getNotes().get(noteIdx);

                    if (minNote == null || currentNote.getDuration().getTime() <= minNote.getDuration().getTime()) {
                        minNote = currentNote;
                    }
                }
                minDuration = minNote.getDuration();
            }
            if(!measure.getSilences().isEmpty()){
                Silence minSilence = null;
                for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
                    Silence currentSilence = (Silence) measure.getSilences().get(silenceIdx);

                    if (minSilence == null || currentSilence.getDuration().getTime() <= minSilence.getDuration().getTime()) {
                        minSilence = currentSilence;
                    }
                }            
                
                if(minDuration == null || minSilence.getDuration().getTime() <= minDuration.getTime()){
                    minDuration = minSilence.getDuration();
                }
            }
            this.quarterSpan = TablatureUtil.getSpanForQuarter(minDuration);
        }
    }

    
    /**
     * Calcula si debe pintar el TimeSignature
     */
    private void calculateTimeSignature() {    
        this.paintTimeSignature = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if(prevMeasure == null){
            this.paintTimeSignature = true;
        }else{
            int thisNumerator = getMeasure().getTimeSignature().getNumerator();
            int thisValue = getMeasure().getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getMeasure().getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getMeasure().getTimeSignature().getDenominator().getValue();            
            if(thisNumerator != prevNumerator || thisValue != prevValue){
                this.paintTimeSignature = true;
            }
        }
    }
    
    /**
     * Calcula si debe pintar el Tempo
     */
    private void calculateTempo() {    
        this.paintTempo = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if(prevMeasure == null){
            this.paintTempo = true;
        }else{         
            if(getMeasure().getTempo().getValue() != prevMeasure.getMeasure().getTempo().getValue()){
                this.paintTempo = true;
            }            
        }
    }    
    
    /**
     * Calcula las coordenadas de los componentes
     */    
    private void calcuateComponents(){
        this.measureComponents.clear();
        calculateComponentsCoords();
    }
    
    /**
     * Calcula las coordenadas de las notas y silencios
     */
    private void calculateComponentsCoords() {
        int posX = 0;
        int posY = 0;        
        //---------------------------------Notas-------------------------------------
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            posY = note.getString() * SongTrackCoords.DEFAULT_STRING_SPAN;
            posX = TablatureUtil.getStartPosition(measure, note.getStart(), this.quarterSpan) + 10;            
            measureComponents.add(new NoteCoords(this.trackCoords,this, note, posX + getTimeSignatureSpan(), posY));
        }
        //---------------------------------Silencios---------------------------------
        for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
            Silence silence = (Silence) measure.getSilences().get(silenceIdx);
            posX = TablatureUtil.getStartPosition(measure, silence.getStart(), this.quarterSpan) + 5;                        
            measureComponents.add(new SilenceCoords(this.tablature,this,silence,posX + getTimeSignatureSpan(),30));
        }        
    }

    /**
     * Calcula si hay espacios libres. y crea nuevos silencios
     */   
    private void autoCompleteSilences(){    
        //----lleno measureComponets con los componenter reales
        measureComponents.clear();
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            measureComponents.add(new NoteCoords(this.trackCoords,this, (Note) measure.getNotes().get(noteIdx),0,0));
        }
        for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {   
            measureComponents.add(new SilenceCoords(this.tablature,this,(Silence) measure.getSilences().get(silenceIdx),0,0));
        }            
        //--------------------------------------------------------------------------------------------
        long start = getMeasure().getStart();
        long end = 0;
        long diff = 0;
        MeasureComponent component = getFirstComponent();
        
        while (component != null) {
            end = component.getStart() + component.getDuration().getTime();  
            if(component.getStart() > start){
                diff = component.getStart() - start;
                if(diff > 0){                                                            
                    createSilences(start,diff);
                }                
            }            
            start = end;       
            component = getNextComponent(component);            
        }        
        end = getMeasure().getStart() + getMeasure().getLength();
        diff = end - start;
        if(diff > 0){       
            createSilences(start,diff);         
        }
    }    
    

    /**
     * Crea Silencios temporarios en base a length
     */    
    private void createSilences(long start,long length){
        List durations = TablatureUtil.createDurations(length);
        Iterator it = durations.iterator();
        while(it.hasNext()){
            Duration duration = (Duration)it.next();
            Silence silence = new Silence(start,duration);
            addSilence(silence);
            start += duration.getTime();
        }
    }    

    /**
     * Llama a update de todas las notas del compas
     */
    private void updateComponents() {
        Iterator it = measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent) it.next();
            component.update();
        }
    }
    
    private void updateCaret(){
        if(this.caret != null){
          if(!this.measureComponents.contains(caret.getSelectedComponent())){
                MeasureComponent component = getComponent(caret.getPosition());
                if(component == null){
                    component = getFirstComponent();
                }                                 
                caret.moveTo(this.trackCoords,this,component);                
            }
        }
    }

    /**
     * Calcula el width del compas
     */
    private void calculateWidth() {                
        TimeSignature timeSignature = getMeasure().getTimeSignature();
        
        double quartersInSignature = ((1.00 / (double)timeSignature.getDenominator().getValue()) * 4.00) * (double)timeSignature.getNumerator();
        
        this.width = (int)((double)this.quarterSpan * quartersInSignature);
        
        this.width += getTimeSignatureSpan();
        
        this.width += DEFAULT_LEFT_SPAN;
        this.width += DEFAULT_RIGHT_SPAN;        
    }

    /**
     * Calcula el width del compas
     */
    private void calculateHeight() {
        this.height = (trackCoords.getTrack().getStrings().size() * SongTrackCoords.DEFAULT_STRING_SPAN);
    }

    
    private void orderNotes(){
        for(int i = 0;i < getMeasure().getNotes().size();i++){
            Note minNote = null;
            for(int noteIdx = i;noteIdx < getMeasure().getNotes().size();noteIdx++){
                Note note = (Note)getMeasure().getNotes().get(noteIdx);
                if(minNote == null || note.getStart() < minNote.getStart()){
                    minNote = note;
                }
            }
            getMeasure().getNotes().remove(minNote);
            getMeasure().getNotes().add(i,minNote);
        }
    }
    
    
    private void orderComponents(){
        for(int i = 0;i < measureComponents.size();i++){
            MeasureComponent minComponent = null;
            for(int j = i;j < measureComponents.size();j++){
                MeasureComponent component = (MeasureComponent)measureComponents.get(j);
                if(minComponent == null || component.getStart() < minComponent.getStart()){
                    minComponent = component;
                }
            }
            measureComponents.remove(minComponent);
            measureComponents.add(i,minComponent);
        }
    }    
    
    /**
     * Pinta el compas
     */
    public void paintMeasure(GC gc, int fromX, int fromY,Rectangle clientArea) {
        paintTempo(gc, fromX, fromY);
        paintTimeSignature(gc, fromX, fromY);
        paintComponents(gc, fromX, fromY,clientArea);
        paintDivisions(gc, fromX, fromY);
        paintCaret(gc,fromX,fromY);
        this.lastFromX = fromX;
        this.lastFromY = fromY;
    }

    /**
     * Pinta las notas
     */
    public void paintComponents(GC gc, int fromX, int fromY,Rectangle clientArea) {   
        if(isPlaying()){
            gc.setForeground(this.tablature.getDisplay().getSystemColor(SWT.COLOR_RED));
        }        
        
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent component = (MeasureComponent) measureComponents.get(noteIdx);                         
            component.paint(gc, fromX + DEFAULT_LEFT_SPAN, fromY);
        }
        
        if(isPlaying()){
            gc.setForeground(new Color(this.tablature.getDisplay(),0, 0, 0));
        }        
    }
    
    /**
     * Pinta las notas
     */
    public void paintCaret(GC gc, int fromX, int fromY) {
        if(hasCaret()){            
            caret.paintCaret(gc, fromX + DEFAULT_LEFT_SPAN + getTimeSignatureSpan(), fromY);
        }
    }    

    /**
     * Pinta las divisiones del compas
     */
    private void paintDivisions(GC gc, int fromX, int fromY) {
        int y1 = fromY + SongTrackCoords.DEFAULT_STRING_SPAN;
        int y2 = fromY + (trackCoords.getTrack().getStrings().size() * SongTrackCoords.DEFAULT_STRING_SPAN);
        //principio
        if(measure.isRepeatStart()){
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);
            
            gc.drawOval(fromX + 7, y1 + ((y2 - y1) / 2) - 7,1,2);
            gc.drawOval(fromX + 7, y1 + ((y2 - y1) / 2) + 7,1,2);
            
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);
        }else if(isFirstMeasure()){
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);    
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);            
    	}else{
            gc.drawLine(fromX, y1, fromX, y2);
        }
        
        //fin
        if(measure.getNumberOfRepetitions() > 0){            
            gc.setLineWidth(3);
            gc.drawLine(fromX + getWidth(), y1, fromX + getWidth(), y2);            

            gc.drawOval(fromX + getWidth() -8, y1 + ((y2 - y1) / 2) - 7,2,2);
            gc.drawOval(fromX + getWidth() -8, y1 + ((y2 - y1) / 2) + 7,2,2);
            
            gc.setLineWidth(1);            
            gc.drawLine(fromX + getWidth() - 3, y1, fromX + getWidth() - 3, y2);
            
            gc.drawString("x" + Integer.toString(measure.getNumberOfRepetitions()),fromX + getWidth() - 10,fromY - 5);
        }else if(isLastMeasure()){
            gc.setLineWidth(3);
            gc.drawLine(fromX + getWidth(), y1, fromX + getWidth(), y2);            
            gc.setLineWidth(1);            
            gc.drawLine(fromX + getWidth() - 3, y1, fromX + getWidth() - 3, y2);      
    	}else{        
            gc.drawLine(fromX + getWidth(), y1, fromX + getWidth(), y2);
        }
        
    }

    
    
    private void paintTimeSignature(GC gc, int fromX, int fromY){
        if(this.paintTimeSignature){
            Font currFont = gc.getFont();
        	gc.setFont(new Font(tablature.getDisplay(),new FontData("Arial",14, SWT.BOLD)));
        
        	int center =  (getHeight() / 2);
        	int x = fromX + DEFAULT_LEFT_SPAN + 10;
        	int y1 = fromY + (center - 12);
        	int y2 = fromY + (center + 5);        
        
        	gc.drawString(Integer.toString(getMeasure().getTimeSignature().getNumerator()),x,y1);
        	gc.drawString(Integer.toString(getMeasure().getTimeSignature().getDenominator().getValue()),x,y2);
    
        	gc.setFont(currFont);
        }
    }
    
    
    private void paintTempo(GC gc, int fromX, int fromY){
        if(this.paintTempo){
            int x = fromX;
            int y = fromY - 10;
            String tempo = "Tempo: " + getMeasure().getTempo().getValue();
            gc.drawString(tempo,x,y);
        }
    }
    /**
     * Retorna true si se esta reproduciendo y la posicion del player esta en este compas.
     */    
    private boolean isPlaying(){
        if(this.songManager.getPlayer().isRunning()){
            long playerTickPosition = this.songManager.getPlayer().getTickPosition();
            if(playerTickPosition >= getMeasure().getStart()  && playerTickPosition < getMeasure().getStart() + getMeasure().getLength()){            
                return true;
            }
        }        
        return false;
    }
    
    /**
     * Retorna el ancho del Compas
     */
    public int getWidth() {
        return this.width;
    }

    /**
     * Retorna el alto del Compas
     */
    public int getHeight() {
        return this.height;
    }
    
    public int getTimeSignatureSpan(){
        int span = 0;
        if(paintTimeSignature){
            span = DEFAULT_TIME_SIGNATURE_SPAN;
        }
        return span;
    }

    /**
     * Retorna el Componente Anterior
     */
    public MeasureComponent getPreviousComponent(MeasureComponent component) {
        MeasureComponent prevComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);

            if (currComponent.getStart() < component.getStart()) {
                if (prevComponent == null) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() > prevComponent.getStart()) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() == prevComponent.getStart()
                        && currComponent.getDuration().getTime() <= prevComponent.getDuration().getTime()) {
                    prevComponent = currComponent;
                }
            }
        }
        return prevComponent;
    }

    /**
     * Retorna el Siguiente Componente
     */
    public MeasureComponent getNextComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
        }
        return nextComponent;
    }

    
    /**
     * Retorna el Primer Componente
     */
    public MeasureComponent getFirstComponent() {
        MeasureComponent firstComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (firstComponent == null || currComponent.getStart() < firstComponent.getStart()) {
                firstComponent = currComponent;
            }
        }
        return firstComponent;
    }    
    
    /**
     * Retorna el Ultimo Componente
     */
    public MeasureComponent getLastComponent() {
        MeasureComponent lastComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (lastComponent == null || lastComponent.getStart() < currComponent.getStart()) {
                lastComponent = currComponent;
            }
        }
        return lastComponent;
    }     
    
    /**
     * Retorna Un Componente en la posicion start
     */
    public MeasureComponent getComponent(long start) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (currComponent.getStart() == start) {
                component = currComponent;
                break;
            }
        }
        return component;
    }        

    /**
     * Retorna Todos los Componentes en la posicion Start
     */
    public List getComponents(long start) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() == start) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponent(long start,int string) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {            
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
                NoteCoords note = (NoteCoords)currComponent;
                if (note.getStart() == start && note.getNote().getString() == string) {
                    component = currComponent;
                    break;
                }
            }
        }
        return component;
    }    
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getComponentsBeforeEnd(long fromStart) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() >= fromStart) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    

    /**
     * Retorna el Siguiente Componente que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }    
    

    /**
     * Retorna el Siguiente Componente que sea de un silencio
     */
    public MeasureComponent getNextSilenceComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof SilenceCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }        
    
    
    /**
     * Retorna el componente mas cercano a X
     */    
    public MeasureComponent getComponentAt(int x){  
        MeasureComponent component = null;        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if(component == null){
                component = currComponent;
            }else{                    
                int distanceX = Math.abs(x - (component.getPosX() + this.lastFromX + DEFAULT_LEFT_SPAN));
                int currDistanceX = Math.abs(x - (currComponent.getPosX() + this.lastFromX + DEFAULT_LEFT_SPAN));
                if(currDistanceX < distanceX){
                    component = currComponent;
                }
            }
            
        }
        return component;
    }          

    
    /**
     * Pinta las cuerdas
     */
    public InstrumentString getStringAt(int y) {
        InstrumentString string = null;
        int minorDistance = 0;
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString currString = (InstrumentString)it.next();                        
            int distanceX = Math.abs(y - ((currString.getNumber() * SongTrackCoords.DEFAULT_STRING_SPAN) + this.lastFromY));            
            if(string == null || distanceX < minorDistance){
                string = currString;
                minorDistance = distanceX;
            }
        }        
            
        return string;    
    }    
    
    
    /**
     * Agrega un componente
     */    
    public void addComponent(MeasureComponent component){
        this.measureComponents.add(component);
    }
    /**
     * Elimina un componente
     */   
    public void removeComponent(MeasureComponent component){
        this.measureComponents.remove(component);
    }    
    
    /**
     * Verifica si contiene el componente
     */   
    public boolean hasComponent(MeasureComponent component){
        return this.measureComponents.contains(component);
    }      
    
    /**
     * Elimina los Componentes que empiecen en Start y esten en la misma cuerda
     * Si hay un Silencio lo borra sin importar la cuerda
     */
    public void removeComponentsAt(long start,int string,boolean addSilence){
        List components = getComponents(start);
        Iterator it = components.iterator();
        while(it.hasNext()){
            MeasureComponent component = (MeasureComponent)it.next();
            if(component instanceof SilenceCoords){
                SilenceCoords sileceComp = (SilenceCoords)component;
                removeSilence(sileceComp.getSilence());
                
            }else if(component instanceof NoteCoords){
                NoteCoords noteComp = (NoteCoords)component;
                if(noteComp.getNote().getString() == string){
                    removeNote(noteComp.getNote());
                    
                    //si era el unico componente agrego un silencio
                    if(addSilence && components.size() == 1){
                        addSilence(new Silence(noteComp.getStart(),(Duration)noteComp.getDuration().clone()));
                    }
                }
            }
        }        
    }
    
    /**
     * Elimina los Componentes que empiecen en Start 
     */
    public void removeAllComponentsAt(long start){
        List components = getComponents(start);
        Iterator it = components.iterator();
        while(it.hasNext()){
            MeasureComponent component = (MeasureComponent)it.next();
            if(component instanceof SilenceCoords){
                SilenceCoords sileceComp = (SilenceCoords)component;
                removeSilence(sileceComp.getSilence());
            }else if(component instanceof NoteCoords){
                NoteCoords noteComp = (NoteCoords)component;                
                removeNote(noteComp.getNote());                
            }
        }        
    }    
    
    /**
     * Agrega una nota al compas
     */
    public void addNote(Note note){                  
        //creo el componente
        int posX = TablatureUtil.getStartPosition(measure,note.getStart(), this.quarterSpan) + 5;  
        MeasureComponent noteComponent = new NoteCoords(this.trackCoords,this,note,posX,30);
        
        //Verifico si entra en el compas
        if(canInsert(noteComponent,true,false)){
            //Borro lo que haya en la misma posicion
            removeComponentsAt(note.getStart(),note.getString(),false);            
            
            //Agrego la nota
            getMeasure().addNote(note);
            measureComponents.add(noteComponent);
            
            
            //trato de agregar un silencio similar al lado
            tryChangeSilenceAfter(noteComponent);

        }        

    }         

    public void tryChangeSilenceAfter(MeasureComponent component){
        autoCompleteSilences();
        MeasureComponent nextComponent = getNextComponent(component);
        
        long componentEnd = component.getStart() + component.getDuration().getTime();
        if(nextComponent instanceof SilenceCoords && componentEnd <= getMeasure().getLength()){
            moveComponent(nextComponent,(getRealStart(componentEnd)) - getRealStart(nextComponent.getStart()));
                        
            //if(areInSameBeat(component,nextComponent)){
                changeDuration(nextComponent,(Duration)component.getDuration().clone());
            //}
        }     
    }

    
    /**
     * Elimina una nota del compas
     */     
    public void removeNote(Note note){
        getMeasure().removeNote(note);
    }    
    
    
    /** 
     * Liga la nota
     */
    public void changeTieNote(long start,int string){
        MeasureComponent component = getComponent(start,string);
        if(component instanceof NoteCoords){
            NoteCoords note = (NoteCoords)component;
            note.getNote().setTiedNote(!note.getNote().isTiedNote());
        }
    }
    
    /**
     * Agrega un silencio al compas
     */
    public void addSilence(Silence silence){        
        //creo el componente
        int posX = TablatureUtil.getStartPosition(measure,silence.getStart(), this.quarterSpan) + 5;  
        MeasureComponent silenceComponent = new SilenceCoords(this.tablature,this,silence,posX,30);
        
        //Verifico si entra en el compas
        if(canInsert(silenceComponent,true,false)){
            //Borro lo que haya en la misma posicion
            removeAllComponentsAt(silence.getStart());             
            
            //Agrego el silencio
            getMeasure().addSilence(silence);
            measureComponents.add(silenceComponent);
        }
        

    }     
    
    
    /**
     * Elimina un silencio del compas.
     */    
    public void removeSilence(Silence silence){
        removeSilence(silence,false);
    }    
    
    /**
     * Elimina un silencio del compas.
     * si se asigna moveNextComponents = true. los componentes que le siguen 
     * se moveran para completar el espacio vacio que dejo el silencio
     */         
    public void removeSilence(Silence silence,boolean moveNextComponents){
        //TODO sacar el calculo de length con el nextComponent cuando en autosilences se agreguen tresillos
        MeasureComponent component = getComponent(silence.getStart());
        MeasureComponent nextComponent = getNextComponent(component);
        
        
        getMeasure().removeSilence(silence);
        if(moveNextComponents){
            long start = silence.getStart();
            long length = silence.getDuration().getTime();
            
            if(nextComponent != null){
                length = nextComponent.getStart() - start;                
            }
            
            moveComponents(start + length,-length);
        }
    }      
    
    
    /**
     * Cambia la Duracion de todos los componentes que se encuentren en start
     */
    public void changeDuration(long start,Duration duration){                
        List components = getComponents(start);
        Iterator it = components.iterator();
        while(it.hasNext()){
            MeasureComponent component = (MeasureComponent)it.next();
            changeDuration(component,duration);
        }
    }    
    
    
    /**
     * Cambia la Duracion del componente.
     */
    public void changeDuration(MeasureComponent component,Duration duration){        
        //obtengo la duracion vieja
        Duration oldDuration = (Duration)component.getDuration().clone();
        
        //asigno la nueva duracion
        component.setDuration((Duration)duration.clone());
        
        //si no entra vuelvo a dejar la vieja
        if(canInsert(component,true,true)){            

            //trato de agregar un silencio similar al lado
            tryChangeSilenceAfter(component);
            
        }else{
            component.setDuration(oldDuration);
        }
        

    }


    /**
     * Mueve los componentes ubicados en start
     */    
    public boolean moveComponents(long start,long theMove){
        //obtengo los datos del compas
        long measureStart = getMeasure().getStart();
        long measureLength = getMeasure().getLength();
        
        //muevo los componentes
        List components = getComponentsBeforeEnd(start);
        moveComponents(components,theMove);
        
        //si el compas no quedo correctamente vuelvo a dejar todo como estaba
        MeasureComponent first = getFirstComponent();
        while(first instanceof SilenceCoords){
            removeSilence(((SilenceCoords)first).getSilence());
            first = getNextComponent(first);
        }
        MeasureComponent last = getLastComponent();
        while(last instanceof SilenceCoords){
            removeSilence(((SilenceCoords)last).getSilence());
            last = getPreviousComponent(last);
        }
        if(first != null && last != null){
            if(first.getStart() < measureStart || (last.getStart() + last.getDuration().getTime()) > (measureStart + measureLength)){
                moveComponents(components,-theMove);
                return false;
            }
        }
        return true;
    }          
    
    
    /**
     * Mueve todos los componentes
     */
    public void moveAllComponents(long theMove){
        moveComponents(this.measureComponents,theMove);
    }    
    
    /**
     * Mueve los componentes
     */    
    private void moveComponents(List components,long theMove){
        Iterator it = components.iterator();
        while(it.hasNext()){
            MeasureComponent component = (MeasureComponent)it.next();
            moveComponent(component,theMove);             
        }       
    }    
        
    
    /**
     * Mueve el componente
     */    
    private void moveComponent(MeasureComponent component,long theMove){
        //obtengo el start viejo
        long componentStart = component.getStart();
        
        //asigno el nuevo start
        component.setStart(componentStart + theMove);                                   
    }
    
    
    /**
     * Indica si esta Vacia la posicion
     */
    public boolean isEmpty(long start){
        return getComponents(start).isEmpty();
    }
    
    /**
     * Verifica si el componente se puede insertar en el compas.
     * si no puede, con la opcion removeSilences, verifica si el motivo por el
     * cual no entra es que lo siguen silencios. de ser asi los borra. 
     */
    public boolean canInsert(MeasureComponent component,boolean removeSilences,boolean tryMove){        
        boolean canInsert = true;
        orderComponents();             
        
        //Verifico si hay lugar para meter la nota-----------------        
        MeasureComponent nextComponent = getNextComponent(component);
        //si el componente es null, verifico el fin del compas
        long componentEnd = component.getStart() + component.getDuration().getTime();
        if(nextComponent == null){
            if(componentEnd > getMeasure().getStart() + getMeasure().getLength()){
                canInsert = false;
            }
        }else if(componentEnd > nextComponent.getStart()){
            canInsert = false;            
    	}
        
        //---Busca si hay espacio disponible de silencios entre el componente y el el que le sigue.. si encuentra lo borra
        if(removeSilences && !canInsert && nextComponent instanceof SilenceCoords){
            //Verifico si lo que sigue es un silencio. y lo borro     
            long nextComponentEnd = 0;
            List nextSilences = new ArrayList();
            while(nextComponent instanceof SilenceCoords){  
            	nextSilences.add(nextComponent);	
            	nextComponentEnd = nextComponent.getStart() + nextComponent.getDuration().getTime();                  
                nextComponent = getNextComponent(nextComponent);
            }
            if(nextComponent == null){
                nextComponentEnd = getMeasure().getStart() + getMeasure().getLength();
            }else if(nextComponent instanceof NoteCoords){
                nextComponentEnd = nextComponent.getStart();
            }
            if(componentEnd <= nextComponentEnd){
                while(!nextSilences.isEmpty()){
                    SilenceCoords currSilence = (SilenceCoords)nextSilences.get(0);
                    getMeasure().removeSilence(currSilence.getSilence());
                    nextSilences.remove(currSilence);
                }
                canInsert = true;                
            }             
        }
        
        //----A PRUEVA--------------------------------------
        
        //---Busca si hay espacio disponible de silencios entre el componente y el final.. si encuentra mueve todo
        if(!canInsert && removeSilences && tryMove){
            //nextComponent = getNextNoteComponent(component);
            nextComponent = getNextComponent(component);
            if(nextComponent != null){
                long requiredLength = (component.getDuration().getTime()  - (nextComponent.getStart() - component.getStart()));
                
                
                long nextSilenceLength = 0;
                List nextSilences = new ArrayList();
                MeasureComponent nextSilence = getNextSilenceComponent(component);
                while(nextSilence instanceof SilenceCoords){  
                	nextSilences.add(nextSilence);	
                	nextSilenceLength += nextSilence.getDuration().getTime();                  
                	nextSilence = getNextSilenceComponent(nextSilence);
                }       
                if(requiredLength <= nextSilenceLength){
                    
                    List components = getComponentsBeforeEnd(nextComponent.getStart());
                    while(!components.isEmpty()){
                        MeasureComponent currComponent = (MeasureComponent)components.get(0);
                        if(currComponent instanceof SilenceCoords){
                            SilenceCoords currSilence = (SilenceCoords)currComponent;
                                                    
                            requiredLength -= currSilence.getDuration().getTime();
                            
                            getMeasure().removeSilence(currSilence.getSilence());                                
                        }else if(requiredLength > 0){
                            moveComponent(currComponent,requiredLength);      
                        }
                        
                        
                        components.remove(0);                        
                    }
                    canInsert = true;     
                }
                
            }
        }
        //---FIN A PRUEVA--------------------------------------
        
        return canInsert;
    }             

    
    public long getBeatLength(){
        return this.beatLength;
    }
    
    public long getRealStart(long currStart){        
        long beatLength = getBeatLength();        
        long start = currStart;
        
        boolean startBeat = (start % beatLength == 0); 
        if(!startBeat){

            
            Duration minDuration = new Duration(Duration.SIXTY_FOURTH,false,new Tupleto(3,2));
            for(int i = 0;i < minDuration.getTime();i++){
                start ++;    
                startBeat = (start % beatLength == 0);     
                if(startBeat){
                   break; 
                }
            }
            if(!startBeat){
                start = currStart;
            }
        }
        
        return start;
    }
    
    
    //public boolean areInSameBeat(Note note1,Note note2){
    public boolean areInSameBeat(MeasureComponent arg0,MeasureComponent arg1){
        long measureEnd = measure.getStart() + getMeasure().getLength();
        long beatLength = getBeatLength();
        long start1 = getRealStart(arg0.getStart());        
        long start2 = getRealStart(arg1.getStart());
        
        long currStart = measure.getStart();
        
        
        boolean finish = false;
        while(!finish){
            if(start1 >= currStart && start1 < currStart + beatLength && start2 >= currStart && start2 < currStart + beatLength){
                return true;
            }
            currStart += beatLength;
            if(currStart > measureEnd){
                finish = true;
            }
        }
        return false;          
    }

    
    
    public void removeNotesAfterString(int string){
        Iterator it = this.measureComponents.iterator();
        while(it.hasNext()){
            MeasureComponent component = (MeasureComponent)it.next();
            if(component instanceof NoteCoords){
                NoteCoords note = (NoteCoords)component;
                if(note.getNote().getString() > string){
                    removeNote(note.getNote());
                }
            }
        }           
    }
    
    /**
     * Retorna true si es el primer compas
     */         
    public boolean isFirstMeasure(){
        return this.measureId == 0;
    }

    /**
     * Retorna true si es el ultimo compas
     */         
    public boolean isLastMeasure(){
        return (this.trackCoords.getTrack().getMeasures().size() == (this.measureId + 1));
    }    
    
    /**
     * Retorna true si el Caret esta en este compas
     */     
    public boolean hasCaret() {
        return caret != null;
    }    
    
    /**
     * Retorna el Caret
     */     
    public Caret getCaret() {
        return caret;
    }
    /**
     * Asigna el Caret a este compas 
     */    
    public void setCaret(Caret caret) {
        this.caret = caret;
    }
    
    
    
    /**
     * Retorna la posicion X dentro del compas 
     */        
    public int getPosX() {
        return posX;
    }
    
    /**
     * Asigna la posicion X dentro del compas 
     */        
    public void setPosX(int posX) {
        this.posX = posX;
    }
    
    /**
     * Retorna la posicion Y dentro del compas 
     */       
    public int getPosY() {
        return posY;
    }
    
    /**
     * Asigna la posicion Y dentro del compas 
     */    
    public void setPosY(int posY) {
        this.posY = posY;
    }
    
    /**
     * Retorna la ultima posicion X asignada 
     */
    public int getLastFromX() {
        return lastFromX;
    }
    /**
     * Retorna la ultima posicion Y asignada 
     */    
    public int getLastFromY() {
        return lastFromY;
    }
    
    
    /**
     * Asigna el span de negras
     */       
    public void setQuarterSpan(int quarterSpan){
        this.quarterSpan = quarterSpan;
    }    
    
    /**
     * Retorna el span de negras
     */       
    public int getQuarterSpan(){
        return this.quarterSpan;
    }
    
    /**
     * Retorna el Compas     
     */
    public Measure getMeasure(){
        return this.measure;
    }
    
    
    public int getMeasureId() {
        return measureId;
    }
    public void setMeasureId(int measureId) {
        this.measureId = measureId;
    }
}