/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class UndoableToolItems implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;   
    
    public UndoableToolItems(TablatureEditor tablatureEditor,ToolBar toolBar){
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }
   
    public void showItems(){                       
        ToolItem undo = new ToolItem(toolBar, SWT.PUSH);
        undo.setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "undo.png")));
        undo.setToolTipText("Undo");
        undo.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                try {
                    tablatureEditor.getUndoManager().undo();
                } catch (CannotUndoException e) {                    
                    e.printStackTrace();
                }
            }
        });

        ToolItem redo = new ToolItem(toolBar, SWT.PUSH);
        redo.setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "redo.png")));
        redo.setToolTipText("Redo");
        redo.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                try {
                    tablatureEditor.getUndoManager().redo();
                } catch (CannotRedoException e) {                    
                    e.printStackTrace();
                }
            }
        });
    }
    
    public void update(){
        
    }  

}

