/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.measure.AddMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.CopyMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoFirstMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoLastMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoNextMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoPreviousMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.PasteMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.RemoveMeasureAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureMenuItem implements ItemContainer{
    private TablatureEditor tablatureEditor;
    private MenuItem measureMenuItem;
    private Menu menu; 
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addMeasure;
    private MenuItem removeMeasure;
    private MenuItem copyMeasure;
    private MenuItem pasteMeasure;
    
    public MeasureMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.measureMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //--First--
        this.first = new MenuItem(this.menu, SWT.PUSH);
        this.first.setText("&First");            
        this.first.addSelectionListener(TuxGuitar.instance().getAction(GoFirstMeasureAction.NAME));        
        //--previous--
        this.previous = new MenuItem(this.menu, SWT.PUSH);
        this.previous.setText("&Previous");            
        this.previous.addSelectionListener(TuxGuitar.instance().getAction(GoPreviousMeasureAction.NAME));        
        //--next--
        this.next = new MenuItem(this.menu, SWT.PUSH);
        this.next.setText("&Next");          
        this.next.addSelectionListener(TuxGuitar.instance().getAction(GoNextMeasureAction.NAME));        
        //--last--
        this.last = new MenuItem(this.menu, SWT.PUSH);
        this.last.setText("&Last");           
        this.last.addSelectionListener(TuxGuitar.instance().getAction(GoLastMeasureAction.NAME));        

        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);          
        //--ADD TRACK--
        this.addMeasure = new MenuItem(this.menu, SWT.PUSH);
        this.addMeasure.setText("&Add Measure");            
        this.addMeasure.addSelectionListener(TuxGuitar.instance().getAction(AddMeasureAction.NAME));         
        //--REMOVE TRACK--
        this.removeMeasure = new MenuItem(this.menu, SWT.PUSH);
        this.removeMeasure.setText("&Remove Measure");            
        this.removeMeasure.addSelectionListener(TuxGuitar.instance().getAction(RemoveMeasureAction.NAME)); 
                
        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);          
        //--COPY--
        this.copyMeasure = new MenuItem(this.menu, SWT.PUSH);
        this.copyMeasure.setText("&Copy Measure");            
        this.copyMeasure.addSelectionListener(TuxGuitar.instance().getAction(CopyMeasureAction.NAME)); 
        //--PASTE--
        this.pasteMeasure = new MenuItem(this.menu, SWT.PUSH);
        this.pasteMeasure.setText("&Paste Measure");       
        this.pasteMeasure.addSelectionListener(TuxGuitar.instance().getAction(PasteMeasureAction.NAME)); 
           
        
        this.measureMenuItem.setText("&Measure");
        this.measureMenuItem.setMenu(menu);        
    }

    
    public void update(){
        Caret caret = tablatureEditor.getTablature().getCaret();        
        SongTrackCoords track = caret.getSongTrackCoords();  
        MeasureCoords measure = caret.getMeasureCoords();
        
        this.previous.setEnabled(measure.getMeasureId() > 0);
        this.next.setEnabled(measure.getMeasureId() + 1 < track.getTrack().getMeasures().size());
    }
}
