/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTimeSignatureAction extends Action{
    public static final String NAME = "CHANGE_TIME_SIGNATURE";
    
    public ChangeTimeSignatureAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell()); 
        return true;
    }

    
    public void showDialog(Shell shell) {
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 10;      
            layout.horizontalSpacing = 10;     
            dialog.setLayout(layout);

            TimeSignature currentTimeSignature = measure.getMeasure().getTimeSignature();
            //-------numerator-------------------------------------
            Label numeratorLabel = new Label(dialog, SWT.NULL);
            numeratorLabel.setText("Numerator:");
            final Combo numerator = new Combo(dialog, SWT.NULL);
            for (int i = 1; i <= 32; i++) {
                numerator.add(Integer.toString(i));
            }            
            numerator.setText(Integer.toString(currentTimeSignature.getNumerator()));
            //-------denominator-------------------------------------
            Label denominatorLabel = new Label(dialog, SWT.NULL);
            denominatorLabel.setText("Denominator:");
            final Combo denominator = new Combo(dialog, SWT.NULL);
            for (int i = 1; i <= 32; i = i * 2) {
                denominator.add(Integer.toString(i));
            }
            denominator.setText(Integer.toString(currentTimeSignature.getDenominator().getValue()));
            
            //--------------------To End Checkbox-------------------------------
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;           
            final Button toEnd = new Button(dialog, SWT.CHECK);
            toEnd.setText("To the end");
            toEnd.setLayoutData(gridData);
            //-----------------------------------------------------------
            
            final Button buttonOK = new Button(dialog, SWT.PUSH);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    boolean toEndValue = toEnd.getSelection();
                    int numeratorValue = Integer.parseInt(numerator.getText());
                    int denominatorValue = Integer.parseInt(denominator.getText());
                    TimeSignature timeSignature = new TimeSignature(numeratorValue,new Duration(denominatorValue));                    
                    setTimeSignature(timeSignature,toEndValue);
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(dialog, SWT.PUSH);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }
    
    
    private void setTimeSignature(TimeSignature timeSignature,boolean toEnd){
        Caret caret = getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        
        songCoords.changeTimeSignature(measure.getMeasure().getStart(),timeSignature,toEnd);
       
        //actualizo la tablatura
        updateTablature();
        caret.update(caret.getMeasureCoords().getMeasure());
        redraw();                
    }    

}
