/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class Action implements SelectionListener,KeyListener,MouseListener{
    private String name;
    private TablatureEditor tablatureEditor;
    	
    public Action(String name,TablatureEditor tablatureEditor){
        this.name = name;
        this.tablatureEditor = tablatureEditor;        
    }

    public abstract boolean doAction(TypedEvent e);

    protected void update(){
        TuxGuitar.instance().getItemContainerManager().updateItems();
    }        
    
    private synchronized void process(TypedEvent e){
        boolean canDo = doAction(e);        
        if(canDo){
            setLastEvent(e);
            update();
        }
    }
    
    public String getName() {
        return name;
    }    
    
    protected synchronized void redraw(){
        this.tablatureEditor.getTablature().redraw();
    }
    
    protected synchronized void updateTablature(){
        this.tablatureEditor.getTablature().updateTablature();
    }

    protected void fireUpdate(int measureId,boolean isNew){
        this.tablatureEditor.getTablature().getSongCoords().fireUpdate(measureId,isNew);       
    }
    
    protected void fireUpdate(int measureId){
        this.fireUpdate(measureId,false);        
    }    
    
    protected TablatureEditor getEditor(){
        return this.tablatureEditor;        
    }
    
    protected TypedEvent getLastEvent(){
        return TuxGuitar.instance().getActionContainer().getLastEvent();
    }
    
    private void setLastEvent(TypedEvent e){
        TuxGuitar.instance().getActionContainer().setLastEvent(e);
    }    
    
    
    public void widgetDefaultSelected(SelectionEvent e) {        
    }
    
    public void widgetSelected(SelectionEvent e) {
        process(e);
    }
    
    public void keyPressed(KeyEvent e) {        
        process(e);
    }

    public void keyReleased(KeyEvent e) {
    }    
    
    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {        
    }

    public void mouseUp(MouseEvent e) {     
        process(e);
    }    
    
}
