/*
 * Created on 25-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import java.io.File;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.song.managers.SongManager;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TuxGuitar {    
    private static TuxGuitar instance;
    private String basePath;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private TablatureEditor tablatureEditor;
    private ActionContainer actionContainer;
    private ItemContainerManager itemContainerManager;
    
    
    
    public static void main(String[] args) {        
        TuxGuitar.instance().displayGUI();
    }

    public TuxGuitar(){
        this.basePath = new File("").getAbsolutePath() + File.separator ;
    }
    
	public static TuxGuitar instance(){
		if (instance == null){
			synchronized(TuxGuitar.class){
				instance = new TuxGuitar();
			}
		}
		
		return instance;
	}    
    
    public void displayGUI() {
        display = new Display();

        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;

        this.shell = new Shell(display);
        this.shell.setLayout(gridLayout);
        this.shell.setText("Tux-Guitar");

        this.songManager = new SongManager();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        
        initActions();
        initItems();

        tablatureEditor.showTablature(shell);                
                
        shell.setSize(640, 480);
        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }

        }
        display.dispose();
        songManager.getPlayer().close();
        System.exit(0);
    }

    private void initItems(){
        this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
        this.itemContainerManager.createMenu(this.shell);
        this.itemContainerManager.createToolbar(this.shell);
    }
    
    private void initActions(){
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }
    
    public Action getAction(String name){
        return this.actionContainer.getAction(name);
    }
    
    public ItemContainerManager getItemContainerManager() {
        return itemContainerManager;
    }    
    
    public ActionContainer getActionContainer(){
        return this.actionContainer;
    }
    
    
    public static String getResourcePath(Object o, String file) {
        return TuxGuitar.instance().basePath + "files" + File.separator + file;
    }
    
    private String getBasePath(){
        return this.basePath;
    }

}