/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class Measure
implements Serializable {
    private long start;
    private List notes;
    private List silences;
    private TimeSignature timeSignature;
    private Tempo tempo;
    private boolean repeatStart;
    private int numberOfRepetitions;
    private long startWidthRepetitions;

    public Measure(long start, List notes, List silences, TimeSignature timeSignature, Tempo tempo, boolean repeatStart, int numberOfRepetitions) {
        this.start = start;
        this.notes = notes;
        this.silences = silences;
        this.timeSignature = timeSignature;
        this.tempo = tempo;
        this.repeatStart = repeatStart;
        this.numberOfRepetitions = numberOfRepetitions;
        this.startWidthRepetitions = this.start;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public List getNotes() {
        return this.notes;
    }

    public void setNotes(List notes) {
        this.notes = notes;
    }

    public void removeNote(Note note) {
        this.notes.remove(note);
    }

    public void addNote(Note note) {
        this.notes.add(note);
    }

    public List getSilences() {
        return this.silences;
    }

    public void setSilences(List silences) {
        this.silences = silences;
    }

    public void removeSilence(Silence silence) {
        this.silences.remove(silence);
    }

    public void addSilence(Silence silence) {
        this.silences.add(silence);
    }

    public TimeSignature getTimeSignature() {
        return this.timeSignature;
    }

    public void setTimeSignature(TimeSignature timeSignature) {
        this.timeSignature = timeSignature;
    }

    public Tempo getTempo() {
        return this.tempo;
    }

    public void setTempo(Tempo tempo) {
        this.tempo = tempo;
    }

    public int getNumberOfRepetitions() {
        return this.numberOfRepetitions;
    }

    public void setNumberOfRepetitions(int numberOfRepetitions) {
        this.numberOfRepetitions = numberOfRepetitions;
    }

    public boolean isRepeatStart() {
        return this.repeatStart;
    }

    public void setRepeatStart(boolean repeatStart) {
        this.repeatStart = repeatStart;
    }

    public long getStartWidthRepetitions() {
        return this.startWidthRepetitions;
    }

    public void setStartWidthRepetitions(long startWidthRepetitions) {
        this.startWidthRepetitions = startWidthRepetitions;
    }

    public long getLength() {
        return (long)this.getTimeSignature().getNumerator() * this.getTimeSignature().getDenominator().getTime();
    }

    public Object clone() {
        long start = this.start;
        boolean repeatStart = this.repeatStart;
        int numberOfRepetitions = this.numberOfRepetitions;
        ArrayList<Object> notes = new ArrayList<Object>();
        ArrayList<Object> silences = new ArrayList<Object>();
        TimeSignature timeSignature = (TimeSignature)this.timeSignature.clone();
        Tempo tempo = (Tempo)this.tempo.clone();
        int i = 0;
        while (i < this.notes.size()) {
            Note note = (Note)this.notes.get(i);
            notes.add(note.clone());
            ++i;
        }
        i = 0;
        while (i < this.silences.size()) {
            Silence silence = (Silence)this.silences.get(i);
            silences.add(silence.clone());
            ++i;
        }
        return new Measure(start, notes, silences, timeSignature, tempo, repeatStart, numberOfRepetitions);
    }
}

