/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.Test;
import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.SongPlayer;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongManager {
    private static int MAX_CHANNELS = 15;
    private Song song;
    private Player player = new SongPlayer(this);

    public SongManager() {
        this.setSong(Test.getSong());
    }

    public void addTrack(SongTrack track) {
        this.getSong().getTracks().add(track);
    }

    public void setSongName(String name) {
        this.getSong().setName(name);
    }

    public Song getSong() {
        return this.song;
    }

    public void newSong() {
        this.setSong(Test.getSong());
    }

    public void save(String fileName) {
        try {
            new TGOutputStream(fileName).write(this.getSong());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void open(String fileName) throws GPFormatException, IOException {
        SongLoader loader = new SongLoader(fileName);
        Song song = loader.load();
        if (song != null) {
            this.setSong(song);
        }
    }

    public void setSong(Song song) {
        this.song = song;
        this.player.reset();
    }

    public Player getPlayer() {
        return this.player;
    }

    public SongTrack getTrack(Measure measure) {
        SongTrack track = null;
        Iterator it = this.getSong().getTracks().iterator();
        while (it.hasNext()) {
            SongTrack currTrack = (SongTrack)it.next();
            if (!currTrack.getMeasures().contains(measure)) continue;
            track = currTrack;
            break;
        }
        return track;
    }

    public int getFreeChannel(int instrument, boolean isPercusion) {
        return SongManager.getFreeChannel(this.getSong().getTracks(), instrument, isPercusion);
    }

    public static int getFreeChannel(List tracks, int instrument, boolean isPercusion) {
        if (isPercusion) {
            return SongTrack.getDefaultPercusionChannel();
        }
        int channel = 0;
        boolean findChannel = false;
        while (!findChannel) {
            findChannel = true;
            int i = 0;
            while (i < tracks.size()) {
                SongTrack track = (SongTrack)tracks.get(i);
                if (track.getChannel() == channel && track.getInstrument() != instrument) {
                    findChannel = false;
                }
                ++i;
            }
            if (!findChannel && ++channel == SongTrack.getDefaultPercusionChannel()) {
                ++channel;
            }
            if (channel > MAX_CHANNELS) break;
        }
        return channel;
    }

    public static List createDefaultInstrumentStrings() {
        ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>();
        strings.add(new InstrumentString(1, 64));
        strings.add(new InstrumentString(2, 59));
        strings.add(new InstrumentString(3, 55));
        strings.add(new InstrumentString(4, 50));
        strings.add(new InstrumentString(5, 45));
        strings.add(new InstrumentString(6, 40));
        return strings;
    }

    public static List createPercusionStrings() {
        ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>();
        int i = 1;
        while (i <= 6) {
            strings.add(new InstrumentString(i, 0));
            ++i;
        }
        return strings;
    }

    public void calculateMeasureStartWidthRepetitions() {
        Iterator it = this.getSong().getTracks().iterator();
        while (it.hasNext()) {
            SongTrack songTrack = (SongTrack)it.next();
            this.calculateMeasureStartWidthRepetitions(songTrack);
        }
    }

    private void calculateMeasureStartWidthRepetitions(SongTrack songTrack) {
        boolean repeatOpen = true;
        long repeatStart = 1000L;
        long repeatEnd = 0L;
        long startMove = 0L;
        int repeatStartIndex = 0;
        int repeatNumber = 0;
        Measure prevMeasure = null;
        int measureIdx = 0;
        while (measureIdx < songTrack.getMeasures().size()) {
            Measure measure = (Measure)songTrack.getMeasures().get(measureIdx);
            if (!repeatOpen || measure.getStart() + measure.getLength() > repeatEnd) {
                measure.setStartWidthRepetitions(measure.getStart() + startMove);
                this.calculateNoteStartWidthRepetitions(measure, startMove);
            }
            if (measure.isRepeatStart()) {
                repeatStartIndex = measureIdx;
                repeatStart = measure.getStart();
                repeatOpen = true;
            }
            if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
                if (repeatNumber < measure.getNumberOfRepetitions()) {
                    repeatEnd = measure.getStart() + measure.getLength();
                    startMove += repeatEnd - repeatStart;
                    measureIdx = repeatStartIndex - 1;
                    ++repeatNumber;
                } else {
                    repeatStart = 0L;
                    repeatNumber = 0;
                    repeatEnd = 0L;
                    repeatOpen = false;
                }
            }
            prevMeasure = measure;
            ++measureIdx;
        }
    }

    private void calculateNoteStartWidthRepetitions(Measure measure, long startMove) {
        int noteIdx = 0;
        while (noteIdx < measure.getNotes().size()) {
            Note note = (Note)measure.getNotes().get(noteIdx);
            note.setStartWidthRepetitions(note.getStart() + startMove);
            ++noteIdx;
        }
    }
}

