/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.widgets.TablaturePaintListener;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;

public class Tablature
extends Composite {
    private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;
    private Point origin = new Point(0, 0);

    public Tablature(Shell shell, int style) {
        super((Composite)shell, style);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.setLayoutData(spec);
        this.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.addPaintListener(new TablaturePaintListener(this));
        final Point origin = new Point(0, 0);
        final ScrollBar hBar = this.getHorizontalBar();
        hBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int hSelection = hBar.getSelection();
                int destX = -hSelection - origin.x;
                Rectangle rect = Tablature.this.getClientArea();
                Tablature.this.getShell().scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                origin.x = -hSelection;
                Tablature.this.redraw();
            }
        });
        final ScrollBar vBar = this.getVerticalBar();
        vBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vSelection = vBar.getSelection();
                int destY = -vSelection - origin.y;
                Rectangle rect = Tablature.this.getBounds();
                Tablature.this.getShell().scroll(0, destY, 0, 0, rect.width, rect.height, false);
                origin.y = -vSelection;
                Tablature.this.redraw();
            }
        });
    }

    public void init() {
        this.songCoords = new SongCoords(this, this.songManager);
        this.caret = new Caret(this, this.songManager, this.songCoords);
    }

    public void updateTablature() {
        this.songCoords.createTracks();
        this.songCoords.updateTracks();
    }

    public void initCaret() {
        SongTrackCoords firstTrack = (SongTrackCoords)this.songCoords.getTrackCoords().get(0);
        this.caret.update((Measure)firstTrack.getTrack().getMeasures().get(0));
    }

    public void paintTablature(GC gc) {
        if (this.songManager.getPlayer().isRunning()) {
            MeasureCoords measure = this.songCoords.getFirstTrack().getMeasure(this.songManager.getPlayer().getTickPosition());
            this.moveScrollTo(measure, 50, this.getClientArea().width - 100, false);
        }
        int hScroll = this.getHorizontalBar().getSelection();
        int vScroll = this.getVerticalBar().getSelection();
        this.songCoords.paintTracks(gc, this.getClientArea(), -hScroll, -vScroll);
        this.width = this.songCoords.getWidth();
        this.height = this.songCoords.getHeight();
        if (this.songManager.getPlayer().isRunning()) {
            gc.drawString("Running position: " + this.songManager.getPlayer().getTickPosition(), 10, 10);
        }
        this.updateScroll();
        if (this.getCaret().hasChanges() && !this.songManager.getPlayer().isRunning()) {
            this.getCaret().setChanges(false);
            this.moveScrollTo(this.getCaret().getMeasureCoords(), 50, this.getClientArea().width - 200, true);
        }
    }

    public void updateScroll() {
        Rectangle rect = this.getBounds();
        Rectangle client = this.getClientArea();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        hBar.setMaximum(this.width + 22);
        vBar.setMaximum(this.height);
        hBar.setThumb(Math.min(rect.width, client.width));
        vBar.setThumb(Math.min(rect.height, client.height));
    }

    public void moveScrollTo(MeasureCoords measure, int leftSencibility, int rightSencibility, boolean redraw) {
        if (measure != null) {
            int selectcionX = this.getHorizontalBar().getSelection();
            int selectionWidth = this.getClientArea().width;
            int measureX = measure.getPosX();
            int measureWidth = measure.getWidth();
            if (measureX <= selectcionX) {
                this.getHorizontalBar().setSelection(measureX - leftSencibility);
                if (redraw) {
                    this.redraw();
                }
            } else if (measureX + measureWidth >= selectcionX + selectionWidth) {
                this.getHorizontalBar().setSelection(measureX - selectionWidth + rightSencibility);
                if (redraw) {
                    this.redraw();
                }
            }
        }
    }

    public void resetScroll() {
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public void changeCursor(int style) {
        this.setCursor(new Cursor((Device)this.getDisplay(), style));
    }
}

