/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.Test;
import org.herac.tuxguitar.gui.tab.widgets.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.widgets.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongCoords {
    private static final int DEFAULT_FIRST_TRACK_SPAN = 50;
    private static final int DEFAULT_TRACK_SPAN = 150;
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;
    private int width;
    private int height;
    private List quarterSpanHelpers;

    public SongCoords(Tablature tablature, SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }

    public void init() {
        this.tracksCoords = new ArrayList();
        this.quarterSpanHelpers = new ArrayList();
    }

    public void createTracks() {
        this.tracksCoords.clear();
        this.quarterSpanHelpers.clear();
        int trackIdx = 0;
        while (trackIdx < this.songManager.getSong().getTracks().size()) {
            SongTrack track = (SongTrack)this.songManager.getSong().getTracks().get(trackIdx);
            SongTrackCoords trackCoords = new SongTrackCoords(this.tablature, this.songManager, track);
            trackCoords.createMeasures();
            this.tracksCoords.add(trackCoords);
            ++trackIdx;
        }
    }

    public void updateTracks() {
        this.width = 0;
        this.height = 0;
        int maxWidth = 0;
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            SongTrackCoords trackCoords = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            trackCoords.updateMeasures();
            if (trackCoords.getWidth() > maxWidth) {
                maxWidth = trackCoords.getWidth();
            }
            this.height += trackCoords.getHeight() + 150;
            ++trackIdx;
        }
        this.width = maxWidth;
        this.updateRepetitions();
    }

    public void fireUpdate(int measureId, boolean isNew) {
        SongTrackCoords trackCoords;
        int maxWidth = 0;
        QuarterSpanHelper quarterSpan = null;
        if (this.getQuarterSpans().size() > measureId) {
            quarterSpan = this.tablature.getSongCoords().getQuarterSpan(measureId);
            quarterSpan.reset();
        } else {
            quarterSpan = new QuarterSpanHelper();
            this.tablature.getSongCoords().getQuarterSpans().add(quarterSpan);
        }
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            trackCoords = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            trackCoords.fireChanges(measureId, quarterSpan, isNew);
            ++trackIdx;
        }
        trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            trackCoords = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            trackCoords.fireUpdate(measureId, quarterSpan);
            if (trackCoords.getWidth() > maxWidth) {
                maxWidth = trackCoords.getWidth();
            }
            ++trackIdx;
        }
        this.width = maxWidth;
    }

    public void updateRepetitions() {
        this.songManager.calculateMeasureStartWidthRepetitions();
    }

    public void paintTracks(GC gc, Rectangle clientArea, int fromX, int fromY) {
        int posY = fromY + 50;
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            SongTrackCoords trackCoords = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            trackCoords.paintTrack(gc, fromX, posY, clientArea);
            posY += 150;
            ++trackIdx;
        }
    }

    public SongTrackCoords getTrackAt(int y, int vScroll) {
        SongTrackCoords trackCoords = null;
        int posY = 50 + vScroll;
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            SongTrackCoords track = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            int trackWidth = track.getWidth();
            int trackHeight = track.getHeight();
            if (y >= posY && y <= posY + trackHeight) {
                trackCoords = track;
            }
            posY += 150;
            ++trackIdx;
        }
        return trackCoords;
    }

    public SongTrackCoords getNextTrack(SongTrackCoords trackCoords) {
        SongTrackCoords track = null;
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            SongTrackCoords currTrack = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            if (currTrack.equals(trackCoords)) {
                int nextIndex = trackIdx + 1;
                if (nextIndex >= this.tracksCoords.size()) break;
                track = (SongTrackCoords)this.tracksCoords.get(nextIndex);
                break;
            }
            ++trackIdx;
        }
        return track;
    }

    public SongTrackCoords getPrevTrack(SongTrackCoords trackCoords) {
        SongTrackCoords track = null;
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            SongTrackCoords currTrack = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            if (currTrack.equals(trackCoords)) {
                int prevIndex = trackIdx - 1;
                if (prevIndex < 0) break;
                track = (SongTrackCoords)this.tracksCoords.get(prevIndex);
                break;
            }
            ++trackIdx;
        }
        return track;
    }

    public SongTrackCoords getTrack(SongTrack songTrack) {
        SongTrackCoords trackCoords = null;
        int trackIdx = 0;
        while (trackIdx < this.tracksCoords.size()) {
            SongTrackCoords currTrack = (SongTrackCoords)this.tracksCoords.get(trackIdx);
            if (currTrack.getTrack().equals(songTrack)) {
                trackCoords = currTrack;
                break;
            }
            ++trackIdx;
        }
        return trackCoords;
    }

    public SongTrackCoords getFirstTrack() {
        SongTrackCoords track = null;
        if (!this.tracksCoords.isEmpty()) {
            track = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return track;
    }

    public SongTrackCoords getLastTrack() {
        SongTrackCoords track = null;
        if (!this.tracksCoords.isEmpty()) {
            track = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return track;
    }

    private SongTrack makeNewTrack(SongTrack songTrack) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        Iterator measureIt = songTrack.getMeasures().iterator();
        while (measureIt.hasNext()) {
            Measure measure = (Measure)measureIt.next();
            long start = measure.getStart();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            measures.add(new Measure(start, new ArrayList(), new ArrayList(), timeSignature, tempo, repeatStart, nombreOfRepetitions));
        }
        List strings = SongManager.createDefaultInstrumentStrings();
        int channel = this.getSongManager().getFreeChannel(0, false);
        return new SongTrack(channel, 0, measures, strings);
    }

    public void createTrack() {
        SongTrack track = null;
        track = this.songManager.getSong().getTracks().isEmpty() ? Test.getDefaultTrack() : this.makeNewTrack(this.getFirstTrack().getTrack());
        this.addTrack(track);
    }

    public void addTrack(SongTrack track) {
        this.songManager.getSong().getTracks().add(track);
    }

    public void removeTrack(SongTrackCoords track) {
        this.removeTrack(track.getTrack());
    }

    public void removeTrack(SongTrack track) {
        this.songManager.getSong().getTracks().remove(track);
    }

    public void changeTimeSignature(long start, TimeSignature timeSignature, boolean toEnd) {
        Iterator it = this.tracksCoords.iterator();
        while (it.hasNext()) {
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeTimeSignature(start, timeSignature, toEnd);
        }
    }

    public void changeTempo(long start, Tempo tempo, boolean toEnd) {
        Iterator it = this.tracksCoords.iterator();
        while (it.hasNext()) {
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeTempo(start, tempo, toEnd);
        }
    }

    public void changeOpenRepeat(long start) {
        Iterator it = this.tracksCoords.iterator();
        while (it.hasNext()) {
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeOpenRepeat(start);
        }
        this.updateRepetitions();
    }

    public void changeCloseRepeat(long start, int numberOfRepetitions) {
        Iterator it = this.tracksCoords.iterator();
        while (it.hasNext()) {
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeCloseRepeat(start, numberOfRepetitions);
        }
        this.updateRepetitions();
    }

    public void addNewMeasureBeforeEnd() {
        Iterator it = this.tracksCoords.iterator();
        while (it.hasNext()) {
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.addNewMeasureBeforeEnd();
        }
    }

    public void removeMeasure(long start) {
        Iterator it = this.tracksCoords.iterator();
        while (it.hasNext()) {
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.removeMeasure(start);
        }
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public List getTrackCoords() {
        return this.tracksCoords;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List getQuarterSpans() {
        return this.quarterSpanHelpers;
    }

    public QuarterSpanHelper getQuarterSpan(int i) {
        return (QuarterSpanHelper)this.quarterSpanHelpers.get(i);
    }

    public void addQuarterSpan(QuarterSpanHelper quarterSpan) {
        this.quarterSpanHelpers.add(quarterSpan);
    }
}

