/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.mouse;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.MeasureComponent;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

public class SelectComponentAction
extends Action {
    public static final String NAME = "SELECT_COMPONENT";

    public SelectComponentAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        if (e instanceof MouseEvent) {
            MeasureCoords measureCoords;
            MouseEvent mouseEvent = (MouseEvent)e;
            SongTrackCoords trackCoords = this.getTrackCoords(mouseEvent.y);
            if (trackCoords != null && (measureCoords = this.getMeasureCoords(trackCoords, mouseEvent.x)) != null) {
                MeasureComponent measureComponent = this.getMeasureComponent(measureCoords, mouseEvent.x);
                InstrumentString instrumentString = this.getMeasureString(measureCoords, mouseEvent.y);
                if (measureComponent != null) {
                    this.getEditor().getTablature().getCaret().moveTo(trackCoords, measureCoords, measureComponent);
                    if (instrumentString != null) {
                        this.getEditor().getTablature().getCaret().setStringNumber(instrumentString.getNumber());
                    }
                    this.getEditor().getTablature().getSongManager().getPlayer().setTickPosition(measureCoords.getMeasure().getStartWidthRepetitions());
                    this.redraw();
                }
            }
            return true;
        }
        return false;
    }

    private SongTrackCoords getTrackCoords(int y) {
        return this.getEditor().getTablature().getSongCoords().getTrackAt(y, -this.getEditor().getTablature().getVerticalBar().getSelection());
    }

    private MeasureCoords getMeasureCoords(SongTrackCoords trackCoords, int x) {
        return trackCoords.getMeasureAt(x, -this.getEditor().getTablature().getHorizontalBar().getSelection());
    }

    private MeasureComponent getMeasureComponent(MeasureCoords measureCoords, int x) {
        return measureCoords.getComponentAt(x);
    }

    private InstrumentString getMeasureString(MeasureCoords measureCoords, int y) {
        return measureCoords.getStringAt(y);
    }
}

