/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;

public class RemoveMeasureAction
extends Action {
    public static final String NAME = "REMOVE_MEASURE";

    public RemoveMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        Caret caret = this.getEditor().getTablature().getCaret();
        MeasureCoords measure = caret.getSongTrackCoords().getNextMeasure(caret.getMeasureCoords());
        if (measure == null) {
            measure = caret.getSongTrackCoords().getPrevMeasure(caret.getMeasureCoords());
        }
        if (measure == null) {
            SongCoords songCoords = caret.getSongCoords();
            SongTrackCoords track = caret.getSongTrackCoords();
            SongTrackCoords nextCaretTrack = caret.getSongCoords().getNextTrack(track);
            if (nextCaretTrack == null) {
                nextCaretTrack = caret.getSongCoords().getPrevTrack(track);
            }
            songCoords.removeTrack(track);
            this.updateTablature();
            if (nextCaretTrack != null) {
                caret.update(nextCaretTrack.getMeasure(caret.getMeasureCoords().getMeasure().getStart()).getMeasure());
            }
        } else {
            caret.getSongCoords().removeMeasure(caret.getMeasureCoords().getMeasure().getStart());
            this.updateTablature();
            caret.update(measure.getMeasure());
        }
        this.redraw();
        return true;
    }
}

