/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.clipboard.ClipBoard;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.tab.widgets.Tablature;
import org.herac.tuxguitar.gui.undo.UndoManager;
import org.herac.tuxguitar.gui.undo.UndoableCreator;
import org.herac.tuxguitar.song.managers.SongManager;

public class TablatureEditor {
    private SongManager songManager;
    private Tablature tablature;
    private UndoManager undoManager;
    private UndoableCreator undoableCreator;
    private ClipBoard clipBoard;
    private MemoryHelper memory;

    public TablatureEditor(SongManager songManager) {
        this.songManager = songManager;
        this.undoManager = new UndoManager();
        this.undoableCreator = new UndoableCreator(this, this.undoManager);
        this.clipBoard = new ClipBoard();
        this.memory = new MemoryHelper();
    }

    public void showTablature(Shell shell) {
        this.tablature = new Tablature(shell, 2816);
        this.tablature.setSongManager(this.songManager);
        this.tablature.init();
        this.tablature.updateTablature();
        this.tablature.initCaret();
        this.initMouseActions();
        this.initKeyActions();
    }

    private void initMouseActions() {
        this.tablature.addMouseListener(TuxGuitar.instance().getAction("SELECT_COMPONENT"));
    }

    private void initKeyActions() {
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("CHANGE_NOTE"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("GO_DOWN"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("GO_UP"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("GO_RIGHT"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("GO_LEFT"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("INSERT_NOTE"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("REMOVE_NOTE"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("INCREMENT_DURATION"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("DECREMENT_DURATION"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("CHANGE_DOTTED_DURATION"));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
    }

    public void resetDefaults() {
        this.getSongManager().getPlayer().reset();
        this.getTablature().resetScroll();
        this.getTablature().updateTablature();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public UndoableCreator getUndoableCreator() {
        return this.undoableCreator;
    }

    public ClipBoard getClipBoard() {
        return this.clipBoard;
    }

    public void notifyMemoryHelper(String fileName) {
        this.memory.notifyOperation(fileName);
    }

    public MemoryHelper getMemoryHelper() {
        return this.memory;
    }
}

