/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class PromptDialog
extends Dialog {
    public PromptDialog(Shell parent, int style) {
        super(parent, style);
    }

    public PromptDialog(Shell parent) {
        this(parent, 0);
    }

    public void confirmEx(String title, String text, String check, String button1, String button2, String button3, final int[] checkValue, final int[] result) {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        shell.setText(title);
        GridLayout gridLayout = new GridLayout();
        shell.setLayout(gridLayout);
        Label label = new Label(shell, 64);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData(data);
        final Button[] buttons = new Button[4];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (buttons[0] != null) {
                    checkValue[0] = buttons[0].getSelection() ? 1 : 0;
                }
                Widget widget = event.widget;
                int i = 1;
                while (i < buttons.length) {
                    if (widget == buttons[i]) {
                        result[0] = i - 1;
                        break;
                    }
                    ++i;
                }
                shell.close();
            }
        };
        if (check != null) {
            buttons[0] = new Button(shell, 32);
            buttons[0].setText(check);
            buttons[0].setSelection(checkValue[0] != 0);
            data = new GridData();
            data.horizontalAlignment = 3;
            buttons[0].setLayoutData(data);
        }
        Composite composite = new Composite(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData(data);
        composite.setLayout(new RowLayout());
        if (button1 != null) {
            buttons[1] = new Button(composite, 8);
            buttons[1].setText(button1);
            buttons[1].addListener(13, listener);
        }
        if (button2 != null) {
            buttons[2] = new Button(composite, 8);
            buttons[2].setText(button2);
            buttons[2].addListener(13, listener);
        }
        if (button3 != null) {
            buttons[3] = new Button(composite, 8);
            buttons[3].setText(button3);
            buttons[3].addListener(13, listener);
        }
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void prompt(String title, String text, String check, final String[] value, final int[] checkValue, final int[] result) {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        if (title != null) {
            shell.setText(title);
        }
        GridLayout gridLayout = new GridLayout();
        shell.setLayout(gridLayout);
        Label label = new Label(shell, 64);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData(data);
        final Text valueText = new Text(shell, 2048);
        if (value[0] != null) {
            valueText.setText(value[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        valueText.setLayoutData(data);
        final Button[] buttons = new Button[3];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (buttons[0] != null) {
                    checkValue[0] = buttons[0].getSelection() ? 1 : 0;
                }
                value[0] = valueText.getText();
                result[0] = event.widget == buttons[1] ? 1 : 0;
                shell.close();
            }
        };
        if (check != null) {
            buttons[0] = new Button(shell, 32);
            buttons[0].setText(check);
            buttons[0].setSelection(checkValue[0] != 0);
            data = new GridData();
            data.horizontalAlignment = 3;
            buttons[0].setLayoutData(data);
        }
        Composite composite = new Composite(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData(data);
        composite.setLayout(new RowLayout());
        buttons[1] = new Button(composite, 8);
        buttons[1].setText(SWT.getMessage("SWT_OK"));
        buttons[1].addListener(13, listener);
        buttons[2] = new Button(composite, 8);
        buttons[2].setText(SWT.getMessage("SWT_Cancel"));
        buttons[2].addListener(13, listener);
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void promptUsernameAndPassword(String title, String text, String check, final String[] user, final String[] pass, final int[] checkValue, final int[] result) {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        shell.setText(title);
        GridLayout gridLayout = new GridLayout();
        shell.setLayout(gridLayout);
        Label label = new Label(shell, 64);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData(data);
        Label userLabel = new Label(shell, 0);
        userLabel.setText(SWT.getMessage("SWT_Username"));
        final Text userText = new Text(shell, 2048);
        if (user[0] != null) {
            userText.setText(user[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        userText.setLayoutData(data);
        Label passwordLabel = new Label(shell, 0);
        passwordLabel.setText(SWT.getMessage("SWT_Password"));
        final Text passwordText = new Text(shell, 0x400800);
        if (pass[0] != null) {
            passwordText.setText(pass[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        passwordText.setLayoutData(data);
        final Button[] buttons = new Button[3];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (buttons[0] != null) {
                    checkValue[0] = buttons[0].getSelection() ? 1 : 0;
                }
                user[0] = userText.getText();
                pass[0] = passwordText.getText();
                result[0] = event.widget == buttons[1] ? 1 : 0;
                shell.close();
            }
        };
        if (check != null) {
            buttons[0] = new Button(shell, 32);
            buttons[0].setText(check);
            buttons[0].setSelection(checkValue[0] != 0);
            data = new GridData();
            data.horizontalAlignment = 3;
            buttons[0].setLayoutData(data);
        }
        Composite composite = new Composite(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData(data);
        composite.setLayout(new RowLayout());
        buttons[1] = new Button(composite, 8);
        buttons[1].setText(SWT.getMessage("SWT_OK"));
        buttons[1].addListener(13, listener);
        buttons[2] = new Button(composite, 8);
        buttons[2].setText(SWT.getMessage("SWT_Cancel"));
        buttons[2].addListener(13, listener);
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

