#
# Include generated dependency files.
#
XAR_SRCS := xar.c
XAR_SRCS := $(patsubst %, src/%, $(XAR_SRCS))
-include $(XAR_SRCS:%.c=%.d)

src_all : src/xar$(EXEEXT) src/ixar$(EXEEXT)

src_install : src/ixar$(EXEEXT)
	/bin/install -c -d $(DESTDIR)$(BINDIR)
	/bin/install -c -m 0755 $< $(DESTDIR)$(BINDIR)/xar$(EXEEXT)
	/bin/install -c -d $(DESTDIR)$(MANDIR)/man1
	/bin/install -c -m 0644 src/xar.1 $(DESTDIR)$(MANDIR)/man1

src_uninstall :
	rm -f $(DESTDIR)/$(BINDIR)/xar$(EXEEXT)
	rm -f $(DESTDIR)/$(MANDIR)/man1/xar.1

src_clean :
	rm -f src/xar$(EXEEXT)
	rm -f src/ixar$(EXEEXT)
	rm -f $(XAR_SRCS:%.c=%.o)
	rm -f $(XAR_SRCS:%.c=%.d)

src_distclean :


ifeq (yes, yes)
LIBRXAR := $(LIBRXAR_S)
endif
ifeq (yes, yes)
LIBRXAR := $(LIBXAR_A)
endif

LOADLIBES :=
ifeq (pei-i386, pei-i386)
LOADLIBES += -lregex
endif

# xar links against librxar, so that it can be run without first installing
# libxar.
src/%$(EXEEXT) : src/%.o $(LIBRXAR)
	@mkdir -p $(@D)
ifneq ($(words "" ), 1)
	$(CC) $(CFLAGS) -o $@ $< /d/usr/eli/utils/xar-1.5.2/lib $(LDFLAGS) $(LIBRXAR) -lbz2 -lz -lcrypto  -L/d/usr/lib -lxml2 -lz -liconv -lws2_32 $(LOADLIBES)
else
	$(CC) $(CFLAGS) -o $@ $< $(LDFLAGS) $(LIBRXAR) -lbz2 -lz -lcrypto  -L/d/usr/lib -lxml2 -lz -liconv -lws2_32 $(LOADLIBES)
endif

ifeq (yes, yes)
LIBXAR := $(LIBXAR_A)
endif
ifeq (yes, yes)
LIBXAR := $(LIBXAR_S)
endif

# ixar is the version of the xar binary that gets installed.
src/i%$(EXEEXT) : src/%.o $(LIBXAR)
	@mkdir -p $(@D)
ifneq ($(words "" ), 1)
	$(CC) $(CFLAGS) -o $@ $< $(LIBDIR) $(LDFLAGS) $(LIBXAR) -lbz2 -lz -lcrypto  -L/d/usr/lib -lxml2 -lz -liconv -lws2_32 $(LOADLIBES)
else
	$(CC) $(CFLAGS) -o $@ $< $(LDFLAGS) $(LIBXAR) -lbz2 -lz -lcrypto  -L/d/usr/lib -lxml2 -lz -liconv -lws2_32 $(LOADLIBES)
endif

src/%.o : src/%.c
	@mkdir -p $(@D)
	$(CC) $(CFLAGS) $(CPPFLAGS) -c $< -o $@
	@$(SHELL) -ec "$(CC) -MM $(CPPFLAGS) $< | sed \"s/\($(subst /,\/,$(notdir $(basename $@)))\)\.o\([ :]*\)/$(subst /,\/,$(strip $(dir $@)))\1.o \2/g\" > $(@:%.o=%.d)"
