/* Emulation of Posix ACLs for Windows.  */

#ifndef ACL_H
#define ACL_H

#include <windows.h>

typedef PSECURITY_DESCRIPTOR acl_t;
/* The next typedef is a small lie: we don't support only "allowed"
   ACEs.  However, the Windows API does not provide a generic ACE
   type, and most other ACEs (at least the ACCESS_DENIED_ACE) have an
   identical structure and layout as this one.  */
typedef PACCESS_ALLOWED_ACE acl_entry_t;
typedef unsigned acl_type_t;

/* Values of acl_type_t  */
#define ACL_TYPE_ACCESS  0
#define ACL_TYPE_DEFAULT 1

typedef unsigned acl_perm_t;

/* Values of acl_perm_t.  Only file-specific access rights and the
   most useful generic rights are supported.  */
#define ACL_READ      FILE_READ_DATA
#define ACL_WRITE     FILE_WRITE_DATA
#define ACL_EXECUTE   FILE_EXECUTE
#define ACL_APPEND    FILE_APPEND_DATA
#define ACL_DELETE    FILE_DELETE_CHILD
#define ACL_READ_ATTR FILE_READ_ATTRIBUTES
#define ACL_WRITE_ATTR FILE_WRITE_ATTRIBUTES
#define ACL_READ_ACL  READ_CONTROL
#define ACL_WRITE_ACL WRITE_DAC
#define ACL_WRITE_OWN WRITE_OWNER

#define ACL_FIRST_ENTRY  0
#define ACL_NEXT_ENTRY   1

extern int    acl_valid (acl_t);
extern acl_t  acl_get_file (const char *, acl_type_t);
extern int    acl_set_file (const char *, acl_type_t, acl_t);
extern int    acl_get_entry (acl_t, int, acl_entry_t *);
extern char * acl_to_text (acl_t, ssize_t *);
extern acl_t  acl_from_text (const char *);
extern int    acl_free (void *);
#endif
