#!/bin/sh
# $Id: mk-dlls.sh.in,v 1.3 2010/12/25 22:25:41 tom Exp $
##############################################################################
# Copyright (c) 2008,2010 Free Software Foundation, Inc.                     #
#                                                                            #
# Permission is hereby granted, free of charge, to any person obtaining a    #
# copy of this software and associated documentation files (the "Software"), #
# to deal in the Software without restriction, including without limitation  #
# the rights to use, copy, modify, merge, publish, distribute, distribute    #
# with modifications, sublicense, and/or sell copies of the Software, and to #
# permit persons to whom the Software is furnished to do so, subject to the  #
# following conditions:                                                      #
#                                                                            #
# The above copyright notice and this permission notice shall be included in #
# all copies or substantial portions of the Software.                        #
#                                                                            #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
# DEALINGS IN THE SOFTWARE.                                                  #
#                                                                            #
# Except as contained in this notice, the name(s) of the above copyright     #
# holders shall not be used in advertising or otherwise to promote the sale, #
# use or other dealings in this Software without prior written               #
# authorization.                                                             #
##############################################################################
#
# Author: Juergen Pfeifer
#
# Build DLLs on MinGW
#
ABI_VERSION="`egrep '^NCURSES_MAJOR[ 	]*=' ./dist.mk | sed -e 's/^[^0-9]*//'`"

LC_ALL=C gcc -v 2>&1 | grep -i target | grep mingw
if [ $? -eq 1 ]; then
  echo "$0 requires a mingw environment" >&2
else
  mkdir "$TEMP/tmp-dll"
  cat > "$TEMP/tmp-dll/arch.c" <<EOF
#include <stdio.h>
int main()
{
    printf("%d",8*sizeof(void*));
    return(0);
}
EOF
  pushd "$TEMP/tmp-dll"
    gcc -o arch arch.c
    ARCH=`./arch`
    cd ..
    rm -rf tmp-dll
  popd
  echo $ARCH > mingw_arch
  echo Building DLLs and Import Libraries for Win${ARCH} and ABI=${ABI_VERSION}

  if [ -d lib ]; then
    cf="-shared"
    lf="--enable-auto-import"
    pushd lib 2>&1 >/dev/null
      for t in "" "t"
      do
        for m in "" "_g"
        do
          if [ -f libncurses${t}${m}.a ]; then
            f=libncurses${t}${m}.a
            g=libncurses${t}
            gi=${g}${m}.dll.a
            td=$TEMP/tmp-${g}${m}
            bd=`pwd`
            rm -rf "${td}"
            mkdir "${td}"
            pushd "${td}"
              ar x "${bd}/${f}" `ar t "${bd}/${f}"`
              gcc $cf -o ${g}${ABI_VERSION}${m}.dll -Wl,--out-implib,${gi} -Wl,--output-def,${g}${m}.def -Wl,$lf `ar t "${bd}/$f"` -lregex.dll
              lib //NOLOGO /MACHINE:i386 /DEF:${g}${m}.def
              rm -f `ar t "${bd}/$f"`
              mv ${g}${ABI_VERSION}${m}.dll "${bd}"
              if [ -f ${g}${m}.lib ]; then
		  mv ${g}${m}.lib "${bd}"
	      fi
              mv ${gi} "${bd}"
            popd
            rm -rf "${td}"

            for l in panel menu form
            do
              for f in lib${l}${t}${m}.a
              do
                g=lib${l}${t}
                td=$TEMP/tmp-${g}${m}
                gi2=${g}${m}.dll.a
                bd=`pwd`
                rm -rf "${td}"
                mkdir "${td}"
                echo $g
                pushd "${td}"
                  ar x "${bd}/$f" `ar t "${bd}/$f"`
                  gcc $cf -o ${g}${ABI_VERSION}${m}.dll -Wl,--out-implib,${gi2} -Wl,--output-def,${g}${m}.def -Wl,$lf `ar t "${bd}/$f"` "${bd}/${gi}" -lregex.dll 
                  lib //NOLOGO /MACHINE:i386 /DEF:${g}${m}.def
                  rm -f `ar t "${bd}/$f"`
                  mv ${g}${ABI_VERSION}${m}.dll "${bd}"
                  if [ -f ${g}${m}.lib ]; then
		      mv ${g}${m}.lib "${bd}"
		  fi
                  mv ${gi2} "${bd}"
                popd
                rm -rf "${td}"
              done
            done
          fi
        done
      done
    popd
  else
    echo lib has not been built >&2
  fi
fi
