/* separate+ 0.5 - image processing plug-in for the Gimp
 *
 * Copyright (C) 2002-2004 Alastair Robinson (blackfive@fakenhamweb.co.uk),
 * Based on code by Andrew Kieschnick and Peter Kirchgessner
 * 2007-2009 Modified by Yoshinori Yamakawa (yamma-ma@users.sourceforge.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include <libgimp/gimp.h>

#include "libgimp/stdplugins-intl.h"

#include "platform.h"

#include "separate.h"
#include "separate-export.h"
#include "tiff.h"
#include "psd.h"
#include "jpeg.h"


gchar *file_extention_table[] =
{
  "tif",
  "tiff",
  "jpg",
  "jpeg",
  "jpe",
  "psd",
  NULL
};

SeparateExportFunc extention_to_func_table[] =
{
  separate_tiff_export,
  separate_tiff_export,
  separate_jpeg_export,
  separate_jpeg_export,
  separate_jpeg_export,
  separate_psd_export,
  NULL
};

SeparateExportFunc export_func_table[] =
{
  separate_tiff_export,
  separate_jpeg_export,
  separate_psd_export
};

void
separate_export (GimpDrawable    *drawable,
                 SeparateContext *sc)
{
  gint32 imageID = sc->imageID;//gimp_drawable_get_image( drawable->drawable_id );
  gchar *filename, *extention;
  gchar *profile_data = NULL;
  gsize profile_length;
  gint32 filetype = sc->sas.filetype;
  gboolean compression = sc->sas.compression;

#ifdef ENABLE_COLOR_MANAGEMENT
  {
    cmsHPROFILE hProfile = NULL;

    if (sc->sas.embedprofile == 3)
      {
        GimpParasite *parasite = gimp_image_parasite_find (imageID, CMYKPROFILE);

        if (parasite)
          {
            profile_length = gimp_parasite_data_size (parasite);
            profile_data = g_memdup (gimp_parasite_data (parasite),
                                     profile_length);
            gimp_parasite_free (parasite);
          }
      }
    else
      {
        gchar *profilefilename;
        switch (sc->sas.embedprofile)
          {
          case 1:
            profilefilename = sc->cmykfilename;
            break;
          case 2:
            profilefilename = sc->prooffilename;
            break;
          default:
            profilefilename = "";
          }
        g_file_get_contents (profilefilename, &profile_data, &profile_length, NULL);
      }
    if (profile_data)
      {
        if ((hProfile = cmsOpenProfileFromMem (profile_data, profile_length)) &&
            cmsGetColorSpace (hProfile) == icSigCmykData)
          { /* profile is OK? */
            /* Profile is embedded, and cannot be used independently */
            profile_data[47] |= 2;
            cmsCloseProfile (hProfile);
          }
        else
          {
            if (hProfile)
              cmsCloseProfile (hProfile);

            g_free (profile_data);
            profile_data = NULL;
            profile_length = 0;
          }
      }
  }
#endif

  filename = gimp_image_get_filename (imageID);

  {
    gint offset = separate_path_get_extention_offset (filename);

    if (offset)
      extention = &filename[offset + 1];
    else
      extention = "";
  }

  if (filetype == -1)
    {
      gint i = 0;

      while (file_extention_table[i])
        {
          if (g_ascii_strcasecmp (file_extention_table[i], extention) == 0)
            {
              (extention_to_func_table[i]) (filename, imageID, profile_data, profile_length, compression);
              break;
            }
          i++;
        }

      if (!file_extention_table[i])
        (extention_to_func_table[0]) (filename, imageID, profile_data, profile_length, compression);
    }
  else
    {
      if (filetype >= 0 && filetype < (sizeof (export_func_table) / sizeof (SeparateExportFunc)))
        (export_func_table[filetype]) (filename, imageID, profile_data, profile_length, compression);
    }

  g_free (filename);
  g_free (profile_data);
}
