/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qtextedit.h>
#include <qprocess.h>

#include "semanage_core.h"
#include "semanage_core_process.h"
//#include "semanage_core2_process.h"

//for debug
#include <iostream>
using namespace std;

//default constructor
SemanageCore::SemanageCore(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("Manage Modules"));
		//lastreloadCheckBox = new QCheckBox(tr("read input only after the last reload"), this);
		//requiresCheckBox = new QCheckBox(tr("generate require statements for rules"), this);
		//referenceCheckBox = new QCheckBox(tr("generate refpolicy style output"), this);
		//verboseCheckBox = new QCheckBox(tr("explain genetated output"), this);
		//explainCheckBox = new QCheckBox(tr("fully explain genetated output"), this);
		//targetedCheckBox->setChecked(true);
		//strictCheckBox->setChecked(true);
		//mlsCheckBox->setChecked(true);
		//passwordLineEdit = new QLineEdit( this );
		//passwordLineEdit->setEchoMode(QLineEdit::Password);
		semanage_coreButton = new QPushButton(tr("&list_modules"), this);
		semanage_core2Button = new QPushButton(tr("&xxxxx"), this);
		closeButton = new QPushButton(tr("&Close"), this);
		semanage_coreButton->setDefault(true);

		connect(semanage_coreButton, SIGNAL(clicked()), this, SLOT(semanage_core_clicked()));
		connect(semanage_core2Button, SIGNAL(clicked()), this, SLOT(semanage_core2_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		QVBoxLayout *leftLayout = new QVBoxLayout;
		//leftLayout->addWidget(lastreloadCheckBox);
		//leftLayout->addWidget(requiresCheckBox);
		//leftLayout->addWidget(referenceCheckBox);
		//leftLayout->addWidget(verboseCheckBox);
		//leftLayout->addWidget(explainCheckBox);

		QVBoxLayout *rightLayout = new QVBoxLayout;
		rightLayout->addWidget(semanage_coreButton);
		rightLayout->addWidget(semanage_core2Button);

		QHBoxLayout *footLayout = new QHBoxLayout;
		footLayout->addStretch(1);
		footLayout->addWidget(closeButton);


		QVBoxLayout *mainLayout = new QVBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(leftLayout);
		mainLayout->addLayout(rightLayout);
		mainLayout->addLayout(footLayout);
		resize(200,100);

		//needs here to be declared for window newly opened unless segmentation fault occurs
		semanage_core_process = 0;
		//semanage_core2_process = 0;
}
void SemanageCore::semanage_core_clicked()
{
	semanage_core_process = new SemanageCoreProcess(this);
	//connect(semanage_core_process, SIGNAL(semanage_core_prosess_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), semanage_core_process, SLOT(close()));
	semanage_core_process->show();
	semanage_core_process->raise();
	semanage_core_process->setActiveWindow();
}
void SemanageCore::semanage_core2_clicked()
{
/*
	semanage_core2_process = new SemanageCore2Process(this);
	connect(semanage_core2_process, SIGNAL(semanage_core2_prosess_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), semanage_core2_process, SLOT(close()));
	semanage_core2_process->show();
	semanage_core2_process->raise();
	semanage_core2_process->setActiveWindow();
*/
}
