/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.util.regex.Pattern;
import org.seasar.framework.util.StringUtil;

public class ClassPattern {
    private String packageName;
    private Pattern[] shortClassNamePatterns;

    public ClassPattern() {
    }

    public ClassPattern(String packageName, String shortClassNames) {
        this.setPackageName(packageName);
        this.setShortClassNames(shortClassNames);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setShortClassNames(String shortClassNames) {
        String[] classNames = StringUtil.split(shortClassNames, ",");
        this.shortClassNamePatterns = new Pattern[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            String s = classNames[i].trim();
            this.shortClassNamePatterns[i] = Pattern.compile(s);
            ++i;
        }
    }

    public boolean isAppliedShortClassName(String shortClassName) {
        if (this.shortClassNamePatterns == null) {
            return true;
        }
        int i = 0;
        while (i < this.shortClassNamePatterns.length) {
            if (this.shortClassNamePatterns[i].matcher(shortClassName).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isAppliedPackageName(String pName) {
        return pName == null ? this.packageName == null : pName.startsWith(this.packageName);
    }
}

