/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepKillException;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.CodeAdapter;
import com.tonicsystems.jarjar.asm.CodeVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.cglib.AbstractClassTransformer;
import com.tonicsystems.jarjar.cglib.Signature;
import java.util.ArrayList;

class DepKillTransformer
extends AbstractClassTransformer {
    private static final Type TYPE_OBJECT = Type.getType(class$java$lang$Object == null ? (class$java$lang$Object = DepKillTransformer.class$("java.lang.Object")) : class$java$lang$Object);
    private String[] packageNames;
    static /* synthetic */ Class class$java$lang$Object;

    public DepKillTransformer(String[] packageNames) {
        this.packageNames = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append('L');
            sb.append(packageNames[i].replace('.', '/'));
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            this.packageNames[i] = sb.toString();
        }
    }

    private boolean checkDesc(String desc) {
        for (int i = 0; i < this.packageNames.length; ++i) {
            if (!desc.startsWith(this.packageNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkMethodDesc(String methodDesc) {
        for (int i = 0; i < this.packageNames.length; ++i) {
            if (methodDesc.indexOf(this.packageNames[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private String fixMethodDesc(String methodDesc) {
        Signature sig = new Signature("foo", methodDesc);
        Type[] args = sig.getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.eraseType(args[i]);
        }
        return new Signature("foo", this.eraseType(sig.getReturnType()), args).getDescriptor();
    }

    private Type eraseType(Type type) {
        return this.checkDesc(type.getDescriptor()) ? TYPE_OBJECT : type;
    }

    private boolean checkName(String name) {
        return this.checkDesc("L" + name + ";");
    }

    private static void replace(CodeVisitor cv, String desc) {
        switch (desc.charAt(0)) {
            case 'V': {
                break;
            }
            case 'D': {
                cv.visitInsn(14);
                break;
            }
            case 'F': {
                cv.visitInsn(11);
                break;
            }
            case 'J': {
                cv.visitInsn(9);
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                cv.visitInsn(3);
                break;
            }
            case 'L': 
            case '[': {
                cv.visitInsn(1);
            }
        }
    }

    private static void pop(CodeVisitor cv, String desc) {
        switch (desc.charAt(0)) {
            case 'D': 
            case 'J': {
                cv.visitInsn(88);
            }
        }
        cv.visitInsn(87);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if (exceptions != null) {
            ArrayList<String> exceptionList = new ArrayList<String>(exceptions.length);
            for (int i = 0; i < exceptions.length; ++i) {
                if (this.checkName(exceptions[i])) continue;
                exceptionList.add(exceptions[i]);
            }
            exceptions = exceptionList.toArray(new String[exceptionList.size()]);
        }
        return new DepKillCodeVisitor(this.cv.visitMethod(access, name, this.fixMethodDesc(desc), exceptions, attrs));
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        if (this.checkDesc(desc)) {
            desc = TYPE_OBJECT.getDescriptor();
        }
        super.visitField(access, name, desc, value, attrs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DepKillCodeVisitor
    extends CodeAdapter {
        public DepKillCodeVisitor(CodeVisitor cv) {
            super(cv);
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[' ? DepKillTransformer.this.checkDesc(desc) : DepKillTransformer.this.checkName(desc)) {
                switch (opcode) {
                    case 187: 
                    case 189: {
                        this.cv.visitInsn(1);
                        break;
                    }
                    case 192: 
                    case 193: {
                        this.cv.visitInsn(3);
                    }
                }
            } else {
                this.cv.visitTypeInsn(opcode, desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (DepKillTransformer.this.checkName(owner) || DepKillTransformer.this.checkDesc(desc)) {
                switch (opcode) {
                    case 180: {
                        this.cv.visitInsn(87);
                        DepKillTransformer.replace(this.cv, desc);
                        break;
                    }
                    case 181: {
                        DepKillTransformer.pop(this.cv, desc);
                        this.cv.visitInsn(87);
                        break;
                    }
                    case 178: {
                        DepKillTransformer.replace(this.cv, desc);
                        break;
                    }
                    case 179: {
                        DepKillTransformer.pop(this.cv, desc);
                    }
                }
            } else {
                this.cv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (DepKillTransformer.this.checkName(owner)) {
                switch (opcode) {
                    case 182: 
                    case 185: {
                        this.cv.visitInsn(87);
                        break;
                    }
                    case 183: {
                        throw new DepKillException("Cannot remove invocation of " + owner + "." + desc);
                    }
                }
                Signature sig = new Signature(name, desc);
                Type[] args = sig.getArgumentTypes();
                for (int i = 0; i < args.length; ++i) {
                    this.cv.visitInsn(args[i].getSize() == 2 ? 88 : 87);
                }
                DepKillTransformer.replace(this.cv, sig.getReturnType().getDescriptor());
            } else if (DepKillTransformer.this.checkMethodDesc(desc)) {
                desc = DepKillTransformer.this.fixMethodDesc(desc);
            } else {
                this.cv.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (DepKillTransformer.this.checkDesc(desc)) {
                this.cv.visitInsn(1);
            } else {
                this.cv.visitMultiANewArrayInsn(desc, dims);
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (!DepKillTransformer.this.checkName(type)) {
                this.cv.visitTryCatchBlock(start, end, handler, type);
            }
        }

        public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
            if (DepKillTransformer.this.checkDesc(desc)) {
                desc = TYPE_OBJECT.getDescriptor();
            }
            this.cv.visitLocalVariable(name, desc, start, end, index);
        }

        public void visitAttribute(Attribute attr) {
            this.cv.visitAttribute(attr);
        }
    }
}

