/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepKillTransformer;
import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.cglib.ClassReaderGenerator;
import com.tonicsystems.jarjar.cglib.DebuggingClassWriter;
import com.tonicsystems.jarjar.cglib.TransformingClassGenerator;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class DepKill {
    public static void main(String[] args) throws Exception {
        new DepKill(args);
    }

    private DepKill(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Syntax: java com.tonicsystems.jarjar.DepKill <input-jar> <package-name> [<package-name> ...] > <output-jar>");
            System.exit(1);
        }
        String[] packageNames = new String[args.length - 1];
        System.arraycopy(args, 1, packageNames, 0, packageNames.length);
        DepKillTransformer t = new DepKillTransformer(packageNames);
        JarFile jar = new JarFile(args[0]);
        JarOutputStream out = new JarOutputStream(new BufferedOutputStream(System.out));
        byte[] buf = new byte[8192];
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            InputStream in = jar.getInputStream(entry);
            entry.setCompressedSize(-1L);
            out.putNextEntry(entry);
            if (entry.getName().endsWith(".class")) {
                ClassReader reader = new ClassReader(in);
                in.close();
                DebuggingClassWriter w = new DebuggingClassWriter(true);
                new TransformingClassGenerator(new ClassReaderGenerator(reader, null, false), t).generateClass(w);
                out.write(w.toByteArray());
                continue;
            }
            DepKill.pipe(in, out, buf);
        }
        jar.close();
        out.close();
    }

    private static void pipe(InputStream in, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = in.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }
}

