/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.auto;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.auto.AutoRegister;
import org.seasar.framework.container.auto.ClassPattern;
import org.seasar.framework.container.impl.AspectDefImpl;

public class InterceptorAutoRegister
extends AutoRegister {
    private String interceptorName;

    public void setInterceptorName(String interceptorName) {
        this.interceptorName = interceptorName;
    }

    public void registAll() {
        S2Container container = this.getContainer();
        int i = 0;
        while (i < container.getComponentDefSize()) {
            ComponentDef cd = container.getComponentDef(i);
            this.regist(cd);
            ++i;
        }
    }

    protected void regist(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        String className = componentClass.getName();
        int i = 0;
        while (i < this.getClassPatternSize()) {
            String shortClassName;
            ClassPattern cp = this.getClassPattern(i);
            String packageName = cp.getPackageName();
            if (className.startsWith(packageName) && cp.isApplied(shortClassName = className.substring(packageName.length() + 1))) {
                this.registInterceptor(componentDef);
                return;
            }
            ++i;
        }
    }

    protected void registInterceptor(ComponentDef componentDef) {
        AspectDefImpl aspectDef = new AspectDefImpl();
        aspectDef.setExpression(this.interceptorName);
        componentDef.addAspectDef(aspectDef);
    }
}

