package test.org.seasar.framework.util;

import java.text.SimpleDateFormat;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.util.DateConversionUtil;

public class DateConversionUtilTest extends TestCase {

	public DateConversionUtilTest(String name) {
		super(name);
	}

	public void testRemoveDelimiter() throws Exception {
		assertEquals("1", "yyyyMMdd", DateConversionUtil
				.removeDelimiter("yyyy/MM/dd"));
	}
	
	public void testGetDateFormat() throws Exception {
		SimpleDateFormat sdf = DateConversionUtil.getDateFormat("2004/11/7");
		assertEquals("1", "yyyy/MM/dd", sdf.toPattern());
	}
	
	public void testGetDateFormat2() throws Exception {
		SimpleDateFormat sdf = DateConversionUtil.getDateFormat("04/11/7");
		assertEquals("1", "yy/MM/dd", sdf.toPattern());
	}
	
	public void testGetDateFormat3() throws Exception {
		SimpleDateFormat sdf = DateConversionUtil.getDateFormat("20041107");
		assertEquals("1", "yyyyMMdd", sdf.toPattern());
	}
	
	public void testGetDateFormat4() throws Exception {
		SimpleDateFormat sdf = DateConversionUtil.getDateFormat("041107");
		assertEquals("1", "yyMMdd", sdf.toPattern());
	}
	
	public void testGetPattern() throws Exception {
		System.out.println(DateConversionUtil.getPattern());
	}
	
	public void testGetDefaultPattern() throws Exception {
		System.out.println(DateConversionUtil.getY4Pattern());
	}
	
	public void testSpike() throws Exception {
		SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
		System.out.println(formatter.parse("041115"));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(DateConversionUtilTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner
				.main(new String[] { DateConversionUtilTest.class.getName() });
	}
}