/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.DecimalFormatUtil;

public final class LongConversionUtil {
    private LongConversionUtil() {
    }

    public static Long toLong(Object o) {
        return LongConversionUtil.toLong(o, null);
    }

    public static Long toLong(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return new Long(((Number)o).longValue());
        }
        if (o instanceof String) {
            return LongConversionUtil.toLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Long(new SimpleDateFormat(pattern).format(o));
            }
            return new Long(((Date)o).getTime());
        }
        return LongConversionUtil.toLong(o.toString());
    }

    private static Long toLong(String s) {
        return new Long(DecimalFormatUtil.normalize(s));
    }

    public static long toPrimitiveLong(Object o) {
        return LongConversionUtil.toPrimitiveLong(o, null);
    }

    public static long toPrimitiveLong(Object o, String pattern) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return LongConversionUtil.toPrimitiveLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Long.parseLong(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return LongConversionUtil.toPrimitiveLong(o.toString());
    }

    private static long toPrimitiveLong(String s) {
        return Long.parseLong(DecimalFormatUtil.normalize(s));
    }
}

