package org.seasar.jsf.util;

import java.io.IOException;
import java.util.Iterator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/**
 * @author higa
 *  
 */
public final class RenderUtil {

	private RenderUtil() {
	}

	public static void encodeChildren(FacesContext context,
			UIComponent component) throws IOException {

		Iterator i = component.getChildren().iterator();
		while (i.hasNext()) {
			encodeChild(context, (UIComponent) i.next());
			if (context.getResponseComplete()) {
				break;
			}
		}
	}

	public static void encodeChild(FacesContext context, UIComponent component)
			throws IOException {

		component.encodeBegin(context);
		if (component.getRendersChildren()) {
			component.encodeChildren(context);
		} else {
			encodeChildren(context, component);
		}
		component.encodeEnd(context);
	}
}