package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.TagProcessorImpl;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class CommandLinkSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "commandLink";

	public CommandLinkSelector() {
	}
	
	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.ANCHOR_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.MAYA_NSURI, JsfConstants.ACTION_ATTR) != null;
	}

	public TagProcessor createProcessor() {
		return new TagProcessorImpl(getInject());
	}
	
	public String getInject() {
		return getJsfHtmlInject(TAG_NAME);
	}
}