package org.seasar.jsf.processor;

import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.exception.TagProcessorNotFoundRuntimeException;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class MetaContentTypeProcessor extends ElementProcessor {

	public MetaContentTypeProcessor() {
	}
	
	public void setup(String namespaceURI, String localName, String qName,
			Attributes attributes, JsfConfig jsfConfig) {

		super.setup(namespaceURI, localName, qName, attributes, jsfConfig);
		String contentType = getProperty(JsfConstants.CONTENT_ATTR);
		if (StringUtil.isEmpty(contentType)) {
			return;
		}
		ViewProcessor viewProcessor = (ViewProcessor) findAncestor(ViewProcessor.class);
		if (viewProcessor == null) {
			throw new TagProcessorNotFoundRuntimeException(ViewProcessor.class);
		}
		viewProcessor.setContentType(contentType);
	}
}