/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.date;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import net.sourceforge.myfaces.component.UserRoleUtils;
import net.sourceforge.myfaces.custom.date.HtmlInputDate;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;
import net.sourceforge.myfaces.util.MessageUtils;

public class HtmlDateRenderer
extends HtmlRenderer {
    public static final String DATE_MESSAGE_ID = "net.sourceforge.myfaces.Date.INVALID";
    private static final String ID_DAY_POSTFIX = ".day";
    private static final String ID_MONTH_POSTFIX = ".month";
    private static final String ID_YEAR_POSTFIX = ".year";
    private static final String ID_HOURS_POSTFIX = ".hours";
    private static final String ID_MINUTES_POSTFIX = ".minutes";
    private static final String ID_SECONDS_POSTFIX = ".seconds";
    static /* synthetic */ Class class$net$sourceforge$myfaces$custom$date$HtmlInputDate;

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        if (uiComponent instanceof HtmlInputDate) {
            return ((HtmlInputDate)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$net$sourceforge$myfaces$custom$date$HtmlInputDate == null ? (class$net$sourceforge$myfaces$custom$date$HtmlInputDate = HtmlDateRenderer.class$("net.sourceforge.myfaces.custom.date.HtmlInputDate")) : class$net$sourceforge$myfaces$custom$date$HtmlInputDate);
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        HtmlInputDate.UserData userData = inputDate.getUserData(currentLocale);
        String type = inputDate.getType();
        String clientId = uiComponent.getClientId(facesContext);
        boolean disabled = this.isDisabled(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        if (!type.equals("time")) {
            HtmlDateRenderer.encodeInputDay(uiComponent, writer, clientId, userData, disabled);
            HtmlDateRenderer.encodeInputMonth(uiComponent, writer, clientId, userData, currentLocale, disabled);
            HtmlDateRenderer.encodeInputYear(uiComponent, writer, clientId, userData, disabled);
        }
        if (type.equals("both")) {
            writer.write(" ");
        }
        if (!type.equals("date")) {
            HtmlDateRenderer.encodeInputHours(uiComponent, writer, clientId, userData, disabled);
            writer.write(":");
            HtmlDateRenderer.encodeInputMinutes(uiComponent, writer, clientId, userData, disabled);
            writer.write(":");
            HtmlDateRenderer.encodeInputSeconds(uiComponent, writer, clientId, userData, disabled);
        }
    }

    private static void encodeInputField(UIComponent uiComponent, ResponseWriter writer, String id, String value, int size, boolean disabled) throws IOException {
        writer.startElement("input", uiComponent);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("size", (Object)Integer.toString(size), null);
        writer.writeAttribute("maxlength", (Object)Integer.toString(size), null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    private static void encodeInputDay(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled) throws IOException {
        HtmlDateRenderer.encodeInputField(uiComponent, writer, clientId + ID_DAY_POSTFIX, userData.getDay(), 2, disabled);
    }

    private static void encodeInputMonth(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, Locale currentLocale, boolean disabled) throws IOException {
        writer.startElement("select", uiComponent);
        writer.writeAttribute("name", (Object)(clientId + ID_MONTH_POSTFIX), null);
        writer.writeAttribute("size", (Object)"1", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        int selectedMonth = userData.getMonth() == null ? -1 : Integer.parseInt(userData.getMonth()) - 1;
        String[] months = HtmlDateRenderer.mapMonths(new DateFormatSymbols(currentLocale));
        for (int i = 0; i < months.length; ++i) {
            String monthName = months[i];
            String monthNumber = Integer.toString(i + 1);
            writer.write("\t\t");
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)monthNumber, null);
            if (i == selectedMonth) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)monthName, null);
            writer.endElement("option");
        }
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    private static void encodeInputYear(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled) throws IOException {
        HtmlDateRenderer.encodeInputField(uiComponent, writer, clientId + ID_YEAR_POSTFIX, userData.getYear(), 4, disabled);
    }

    private static void encodeInputHours(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled) throws IOException {
        HtmlDateRenderer.encodeInputField(uiComponent, writer, clientId + ID_HOURS_POSTFIX, userData.getHours(), 2, disabled);
    }

    private static void encodeInputMinutes(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled) throws IOException {
        HtmlDateRenderer.encodeInputField(uiComponent, writer, clientId + ID_MINUTES_POSTFIX, userData.getMinutes(), 2, disabled);
    }

    private static void encodeInputSeconds(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled) throws IOException {
        HtmlDateRenderer.encodeInputField(uiComponent, writer, clientId + ID_SECONDS_POSTFIX, userData.getSeconds(), 2, disabled);
    }

    private static String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$net$sourceforge$myfaces$custom$date$HtmlInputDate == null ? (class$net$sourceforge$myfaces$custom$date$HtmlInputDate = HtmlDateRenderer.class$("net.sourceforge.myfaces.custom.date.HtmlInputDate")) : class$net$sourceforge$myfaces$custom$date$HtmlInputDate);
        if (this.isDisabled(facesContext, uiComponent)) {
            return;
        }
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        HtmlInputDate.UserData userData = inputDate.getUserData(currentLocale);
        String clientId = inputDate.getClientId(facesContext);
        String type = inputDate.getType();
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        if (!type.equals("time")) {
            userData.setDay((String)requestMap.get(clientId + ID_DAY_POSTFIX));
            userData.setMonth((String)requestMap.get(clientId + ID_MONTH_POSTFIX));
            userData.setYear((String)requestMap.get(clientId + ID_YEAR_POSTFIX));
        }
        if (!type.equals("date")) {
            userData.setHours((String)requestMap.get(clientId + ID_HOURS_POSTFIX));
            userData.setMinutes((String)requestMap.get(clientId + ID_MINUTES_POSTFIX));
            userData.setSeconds((String)requestMap.get(clientId + ID_SECONDS_POSTFIX));
        }
        inputDate.setSubmittedValue(userData);
    }

    public Object getConvertedValue(FacesContext context, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        HtmlInputDate.UserData userData = (HtmlInputDate.UserData)submittedValue;
        try {
            return userData.parse();
        }
        catch (ParseException e) {
            Object[] args = new Object[]{uiComponent.getId()};
            throw new ConverterException(MessageUtils.getMessage(FacesMessage.SEVERITY_ERROR, DATE_MESSAGE_ID, args));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

