/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.calendar;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import net.sourceforge.myfaces.component.html.ext.HtmlInputText;
import net.sourceforge.myfaces.custom.calendar.HtmlInputCalendar;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlCalendarRenderer
extends HtmlRenderer {
    static /* synthetic */ Class class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar;

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("net.sourceforge.myfaces.custom.calendar.HtmlInputCalendar")) : class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar);
        HtmlInputCalendar inputCalendar = (HtmlInputCalendar)component;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        Date value = (Date)inputCalendar.getValue();
        Calendar timeKeeper = Calendar.getInstance(currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = this.mapWeekdays(symbols);
        String[] months = this.mapMonths(symbols);
        if (inputCalendar.isRenderAsPopup()) {
            String dateFormat = CalendarDateTimeConverter.createJSPopupFormat(facesContext, inputCalendar.getPopupDateFormat());
            Application application = facesContext.getApplication();
            HtmlInputText inputText = (HtmlInputText)application.createComponent("net.sourceforge.myfaces.HtmlInputText");
            RendererUtils.copyHtmlInputTextAttributes(inputCalendar, inputText);
            inputText.setTransient(true);
            inputText.setValue(this.getConverter((UIInput)inputCalendar).getAsString(facesContext, (UIComponent)inputCalendar, inputCalendar.getValue()));
            inputText.setEnabledOnUserRole(inputCalendar.getEnabledOnUserRole());
            inputText.setVisibleOnUserRole(inputCalendar.getVisibleOnUserRole());
            inputCalendar.getChildren().add(inputText);
            RendererUtils.renderChild(facesContext, (UIComponent)inputText);
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("script", null);
            writer.writeAttribute("language", (Object)"JavaScript", null);
            writer.writeText((Object)this.getLocalizedLanguageScript(symbols, months, timeKeeper.getFirstDayOfWeek(), inputCalendar), null);
            writer.writeText((Object)this.getScriptBtnText(inputCalendar.getClientId(facesContext), dateFormat, inputCalendar.getPopupButtonString()), null);
            writer.endElement("script");
        } else {
            int lastDayInMonth = timeKeeper.getActualMaximum(5);
            int currentDay = timeKeeper.get(5);
            if (currentDay > lastDayInMonth) {
                currentDay = lastDayInMonth;
            }
            timeKeeper.set(5, 1);
            int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(timeKeeper.get(7));
            int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(timeKeeper.getFirstDayOfWeek());
            ResponseWriter writer = facesContext.getResponseWriter();
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("table", component);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.EVENT_HANDLER_ATTRIBUTES);
            writer.flush();
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (inputCalendar.getMonthYearRowClass() != null) {
                writer.writeAttribute("class", (Object)inputCalendar.getMonthYearRowClass(), null);
            }
            this.writeMonthYearHeader(facesContext, writer, (UIInput)inputCalendar, timeKeeper, currentDay, weekdays, months);
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (inputCalendar.getWeekRowClass() != null) {
                writer.writeAttribute("class", (Object)inputCalendar.getWeekRowClass(), null);
            }
            this.writeWeekDayNameHeader(weekStartsAtDayIndex, weekdays, facesContext, writer, (UIInput)inputCalendar);
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            this.writeDays(facesContext, writer, inputCalendar, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, weekdays);
            writer.endElement("table");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getLocalizedLanguageScript(DateFormatSymbols symbols, String[] months, int firstDayOfWeek, HtmlInputCalendar inputCalendar) {
        void var6_6;
        String[] weekDays;
        int realFirstDayOfWeek = firstDayOfWeek - 1;
        if (realFirstDayOfWeek == 0) {
            weekDays = this.mapWeekdaysStartingWithSunday(symbols);
        } else if (realFirstDayOfWeek == 1) {
            weekDays = this.mapWeekdays(symbols);
        } else {
            throw new IllegalStateException("Week may only start with sunday or monday.");
        }
        StringBuffer script = new StringBuffer();
        script.append("<!--\n");
        this.defineStringArray(script, "jscalendarMonthName", months);
        this.defineStringArray(script, "jscalendarDayName", (String[])var6_6);
        this.setIntegerVariable(script, "jscalendarStartAt", realFirstDayOfWeek);
        if (inputCalendar.getPopupGotoString() != null) {
            this.setStringVariable(script, "jscalendarGotoString", inputCalendar.getPopupGotoString());
        }
        if (inputCalendar.getPopupTodayString() != null) {
            this.setStringVariable(script, "jscalendarTodayString", inputCalendar.getPopupTodayString());
        }
        if (inputCalendar.getPopupWeekString() != null) {
            this.setStringVariable(script, "jscalendarWeekString", inputCalendar.getPopupWeekString());
        }
        if (inputCalendar.getPopupScrollLeftMessage() != null) {
            this.setStringVariable(script, "jscalendarScrollLeftMessage", inputCalendar.getPopupScrollLeftMessage());
        }
        if (inputCalendar.getPopupScrollRightMessage() != null) {
            this.setStringVariable(script, "jscalendarScrollRightMessage", inputCalendar.getPopupScrollRightMessage());
        }
        if (inputCalendar.getPopupSelectMonthMessage() != null) {
            this.setStringVariable(script, "jscalendarSelectMonthMessage", inputCalendar.getPopupSelectMonthMessage());
        }
        if (inputCalendar.getPopupSelectYearMessage() != null) {
            this.setStringVariable(script, "jscalendarSelectYearMessage", inputCalendar.getPopupSelectYearMessage());
        }
        if (inputCalendar.getPopupSelectDateMessage() != null) {
            this.setStringVariable(script, "jscalendarSelectDateMessage", inputCalendar.getPopupSelectDateMessage());
        }
        return script.toString();
    }

    private void setIntegerVariable(StringBuffer script, String name, int value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private void setStringVariable(StringBuffer script, String name, String value) {
        script.append(name);
        script.append(" = \"");
        script.append(value);
        script.append("\";\n");
    }

    private void defineStringArray(StringBuffer script, String arrayName, String[] array) {
        script.append(arrayName);
        script.append(" = new Array(");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                script.append(",");
            }
            script.append("\"");
            script.append(array[i]);
            script.append("\"");
        }
        script.append(");");
    }

    private String getScriptBtnText(String clientId, String dateFormat, String popupButtonString) {
        StringBuffer script = new StringBuffer();
        script.append("if (!document.layers) {\n");
        script.append("document.write(");
        script.append("\"<input type='button' onclick='jscalendarPopUpCalendar(this,this.form.elements[\\\"");
        script.append(clientId);
        script.append("\\\"],\\\"");
        script.append(dateFormat);
        script.append("\\\")' value='");
        if (popupButtonString == null) {
            popupButtonString = "...";
        }
        script.append(popupButtonString);
        script.append("'/>\"");
        script.append(");");
        script.append("\n}");
        script.append("\n//-->");
        return script.toString();
    }

    private void writeMonthYearHeader(FacesContext facesContext, ResponseWriter writer, UIInput inputComponent, Calendar timeKeeper, int currentDay, String[] weekdays, String[] months) throws IOException {
        Calendar cal = this.shiftMonth(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(facesContext, writer, inputComponent, "<", cal.getTime(), null);
        writer.startElement("td", (UIComponent)inputComponent);
        writer.writeAttribute("colspan", (Object)new Integer(weekdays.length - 2), null);
        writer.writeText((Object)(months[timeKeeper.get(2)] + " " + timeKeeper.get(1)), null);
        writer.endElement("td");
        cal = this.shiftMonth(facesContext, timeKeeper, currentDay, 1);
        this.writeCell(facesContext, writer, inputComponent, ">", cal.getTime(), null);
    }

    private Calendar shiftMonth(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(2, cal.get(2) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar copyCalendar(FacesContext facesContext, Calendar timeKeeper) {
        Calendar cal = Calendar.getInstance(facesContext.getViewRoot().getLocale());
        cal.set(1, timeKeeper.get(1));
        cal.set(2, timeKeeper.get(2));
        cal.set(11, timeKeeper.get(11));
        cal.set(12, timeKeeper.get(12));
        cal.set(13, timeKeeper.get(13));
        cal.set(14, timeKeeper.get(14));
        return cal;
    }

    private void writeWeekDayNameHeader(int weekStartsAtDayIndex, String[] weekdays, FacesContext facesContext, ResponseWriter writer, UIInput inputComponent) throws IOException {
        int i;
        for (i = weekStartsAtDayIndex; i < weekdays.length; ++i) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
        }
        for (i = 0; i < weekStartsAtDayIndex; ++i) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
        }
    }

    private void writeDays(FacesContext facesContext, ResponseWriter writer, HtmlInputCalendar inputComponent, Calendar timeKeeper, int currentDay, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, String[] weekdays) throws IOException {
        int i;
        int space;
        int n = space = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : weekdays.length - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (space == weekdays.length) {
            space = 0;
        }
        int columnIndexCounter = 0;
        for (i = 0; i < space; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)inputComponent);
            }
            this.writeCell(facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass());
            ++columnIndexCounter;
        }
        for (i = 0; i < lastDayInMonth; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)inputComponent);
            }
            Calendar cal = this.copyCalendar(facesContext, timeKeeper);
            cal.set(5, i + 1);
            String cellStyle = inputComponent.getDayCellClass();
            if (currentDay - 1 == i) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            this.writeCell(facesContext, writer, (UIInput)inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle);
            if (++columnIndexCounter != weekdays.length) continue;
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            columnIndexCounter = 0;
        }
        if (columnIndexCounter != 0) {
            for (i = columnIndexCounter; i < weekdays.length; ++i) {
                this.writeCell(facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass());
            }
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        }
    }

    private void writeCell(FacesContext facesContext, ResponseWriter writer, UIInput component, String content, Date valueForLink, String styleClass) throws IOException {
        writer.startElement("td", (UIComponent)component);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (valueForLink == null) {
            writer.writeText((Object)content, "value");
        } else {
            this.writeLink(content, component, facesContext, valueForLink);
        }
        writer.endElement("td");
    }

    private void writeLink(String content, UIInput component, FacesContext facesContext, Date valueForLink) throws IOException {
        Converter converter = this.getConverter(component);
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(component.getId() + "_" + valueForLink.getTime() + "_link");
        link.setTransient(true);
        link.setImmediate(component.isImmediate());
        HtmlOutputText text = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
        text.setValue((Object)content);
        text.setId(component.getId() + "_" + valueForLink.getTime() + "_text");
        text.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_param");
        parameter.setTransient(true);
        parameter.setName(component.getClientId(facesContext));
        parameter.setValue((Object)converter.getAsString(facesContext, (UIComponent)component, (Object)valueForLink));
        component.getChildren().add(link);
        link.getChildren().add(parameter);
        link.getChildren().add(text);
        RendererUtils.renderChild(facesContext, (UIComponent)link);
    }

    private Converter getConverter(UIInput component) {
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        return converter;
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    private String[] mapWeekdaysStartingWithSunday(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    private String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("net.sourceforge.myfaces.custom.calendar.HtmlInputCalendar")) : class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar);
        HtmlRendererUtils.decodeUIInput(facesContext, component);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar == null ? (class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar = HtmlCalendarRenderer.class$("net.sourceforge.myfaces.custom.calendar.HtmlInputCalendar")) : class$net$sourceforge$myfaces$custom$calendar$HtmlInputCalendar);
        UIInput uiInput = (UIInput)uiComponent;
        Converter converter = uiInput.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        if (!(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        return converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CalendarDateTimeConverter
    implements Converter {
        public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
            if (s == null || s.trim().length() == 0) {
                return null;
            }
            SimpleDateFormat dateFormat = null;
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((HtmlInputCalendar)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat));
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            try {
                return dateFormat.parse(s);
            }
            catch (ParseException e) {
                ConverterException ex = new ConverterException((Throwable)e);
                throw ex;
            }
        }

        public static String createJSPopupFormat(FacesContext facesContext, String popupDateFormat) {
            if (popupDateFormat == null) {
                SimpleDateFormat defaultDateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
                popupDateFormat = defaultDateFormat.toPattern();
            }
            StringBuffer jsPopupDateFormat = new StringBuffer();
            for (int i = 0; i < popupDateFormat.length(); ++i) {
                char c = popupDateFormat.charAt(i);
                if (c == 'M') {
                    jsPopupDateFormat.append('M');
                    continue;
                }
                if (c == 'd') {
                    jsPopupDateFormat.append('d');
                    continue;
                }
                if (c == 'y') {
                    jsPopupDateFormat.append('y');
                    continue;
                }
                if (c == ' ') {
                    jsPopupDateFormat.append(' ');
                    continue;
                }
                if (c == '.') {
                    jsPopupDateFormat.append('.');
                    continue;
                }
                if (c != '/') continue;
                jsPopupDateFormat.append('/');
            }
            return jsPopupDateFormat.toString().trim();
        }

        public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
            Date date = (Date)o;
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = null;
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                String popupDateFormat = ((HtmlInputCalendar)uiComponent).getPopupDateFormat();
                dateFormat = new SimpleDateFormat(CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat));
            } else {
                dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            }
            return dateFormat.format(date);
        }

        private static SimpleDateFormat createStandardDateFormat(FacesContext facesContext) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, facesContext.getViewRoot().getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                return (SimpleDateFormat)dateFormat;
            }
            return new SimpleDateFormat("dd.MM.yyyy");
        }
    }
}

