/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.groovy.servlet;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class S2GroovyServlet
extends HttpServlet
implements ResourceConnector {
    public static final String CONFIG_PATH_KEY = "configPath";
    private static GroovyScriptEngine gse;
    private static ClassLoader parent;
    private static Map servletCache;
    private ServletContext sc;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        servletCache = Collections.synchronizedMap(new HashMap());
    }

    public static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void destroy() {
        SingletonS2ContainerFactory.destroy();
    }

    public URLConnection getResourceConnection(String name) throws ResourceException {
        try {
            URL url = this.sc.getResource("/" + name);
            if (url == null && (url = this.sc.getResource("/WEB-INF/groovy/" + name)) == null) {
                throw new ResourceException("Resource " + name + " not found");
            }
            return url.openConnection();
        }
        catch (IOException ioe) {
            throw new ResourceException("Problem reading resource " + name);
        }
    }

    public ServletContext getServletContext() {
        return this.sc;
    }

    public void init() {
        this.initGroovy();
        this.initS2();
    }

    protected void initGroovy() {
        ServletConfig config = this.getServletConfig();
        MetaClass.setUseReflection((boolean)true);
        this.sc = config.getServletContext();
        this.sc.log("Groovy servlet initialized");
        parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("groovy.servlet.GroovyServlet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            parent = clazz.getClassLoader();
        }
        gse = new GroovyScriptEngine((ResourceConnector)this);
    }

    protected void initS2() {
        ServletConfig config = this.getServletConfig();
        String configPath = null;
        if (config != null) {
            configPath = config.getInitParameter(CONFIG_PATH_KEY);
        }
        if (!StringUtil.isEmpty(configPath)) {
            SingletonS2ContainerFactory.setConfigPath((String)configPath);
        }
        SingletonS2ContainerFactory.setServletContext((ServletContext)this.getServletContext());
        SingletonS2ContainerFactory.init();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        S2Container container = S2GroovyServlet.getContainer();
        container.setRequest(httpRequest);
        int contextLength = httpRequest.getContextPath().length();
        final String scriptFilename = httpRequest.getRequestURI().substring(contextLength).substring(1);
        final Binding binding = new Binding();
        binding.setVariable("request", (Object)httpRequest);
        binding.setVariable("response", (Object)httpResponse);
        binding.setVariable("application", (Object)this.sc);
        binding.setVariable("session", (Object)httpRequest.getSession(true));
        binding.setVariable("out", (Object)httpResponse.getWriter());
        binding.setVariable("container", (Object)container);
        Enumeration paramEnum = request.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            String key = (String)paramEnum.nextElement();
            if (binding.getVariable(key) != null) continue;
            String[] values = request.getParameterValues(key);
            if (values.length == 1) {
                binding.setVariable(key, (Object)values[0]);
                continue;
            }
            binding.setVariable(key, (Object)values);
        }
        response.setContentType("text/html");
        try {
            Closure closure = new Closure(gse){

                public Object call() {
                    try {
                        return ((GroovyScriptEngine)this.getDelegate()).run(scriptFilename, binding);
                    }
                    catch (ResourceException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            ArrayList categories = new ArrayList();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("groovy.servlet.ServletCategory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            categories.add(clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.seasar.groovy.servlet.S2GroovyServletCategory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            categories.add(clazz2);
            GroovyCategorySupport.use(categories, (Closure)closure);
        }
        catch (RuntimeException re) {
            Throwable e = re.getCause();
            if (e instanceof ResourceException) {
                httpResponse.sendError(404);
            }
            if (e != null) {
                this.sc.log("An error occurred processing the request", e);
            } else {
                this.sc.log("An error occurred processing the request", (Throwable)re);
            }
            httpResponse.sendError(500);
        }
    }

    private static class ServletCacheEntry {
        private Map dependencies = new HashMap();
        private long lastModified;
        private Class servletScriptClass;

        ServletCacheEntry() {
        }
    }
}

