/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;

public class GroovySocketServer
implements Runnable {
    private URL url;
    private GroovyShell groovy;
    private boolean isScriptFile;
    private String scriptLocation;
    private boolean autoOutput;

    public GroovySocketServer(GroovyShell groovy, boolean isScriptFile, String scriptLocation, boolean autoOutput, int port) {
        this.groovy = groovy;
        this.isScriptFile = isScriptFile;
        this.scriptLocation = scriptLocation;
        this.autoOutput = autoOutput;
        try {
            this.url = new URL("http", InetAddress.getLocalHost().getHostAddress(), port, "/");
            System.out.println("groovy is listening on port " + port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Thread(this).start();
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.url.getPort());
            while (true) {
                Script script = this.isScriptFile ? this.groovy.parse(new File(this.scriptLocation)) : this.groovy.parse(this.scriptLocation, "main");
                new GroovyClientConnection(script, this.autoOutput, serverSocket.accept());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    class GroovyClientConnection
    implements Runnable {
        private Script script;
        private Socket socket;
        private BufferedReader reader;
        private PrintWriter writer;
        private boolean autoOutput;

        GroovyClientConnection(Script script, boolean autoOutput, Socket socket) throws IOException {
            this.script = script;
            this.autoOutput = autoOutput;
            this.socket = socket;
            this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.writer = new PrintWriter(socket.getOutputStream());
            new Thread((Runnable)this, "Groovy client connection - " + socket.getInetAddress().getHostAddress()).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            String line = null;
            this.script.setProperty("out", this.writer);
            this.script.setProperty("socket", this.socket);
            this.script.setProperty("init", Boolean.TRUE);
            while ((line = this.reader.readLine()) != null) {
                this.script.setProperty("line", line);
                Object o = this.script.run();
                this.script.setProperty("init", Boolean.FALSE);
                if (o != null) {
                    if ("success".equals(o)) break;
                    if (this.autoOutput) {
                        this.writer.println(o);
                    }
                }
                this.writer.flush();
            }
            Object var4_4 = null;
            try {
                this.writer.flush();
                this.writer.close();
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var4_5 = null;
                    try {
                        this.writer.flush();
                        this.writer.close();
                    }
                    finally {
                        try {
                            this.socket.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.writer.flush();
                    this.writer.close();
                }
                finally {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }
}

