/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.servlet.ServletCategory;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.runtime.GroovyCategorySupport;

public class GroovyServlet
extends HttpServlet
implements ResourceConnector {
    private ServletContext sc;
    private static Map servletCache = Collections.synchronizedMap(new HashMap());
    private static ClassLoader parent;
    private static GroovyScriptEngine gse;

    public ServletContext getServletContext() {
        return this.sc;
    }

    public void init(ServletConfig config) {
        MetaClass.setUseReflection(true);
        this.sc = config.getServletContext();
        this.sc.log("Groovy servlet initialized");
        parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = GroovyServlet.class.getClassLoader();
        }
        gse = new GroovyScriptEngine(this);
    }

    public URLConnection getResourceConnection(String name) throws ResourceException {
        try {
            URL url = this.sc.getResource("/" + name);
            if (url == null && (url = this.sc.getResource("/WEB-INF/groovy/" + name)) == null) {
                throw new ResourceException("Resource " + name + " not found");
            }
            return url.openConnection();
        }
        catch (IOException ioe) {
            throw new ResourceException("Problem reading resource " + name);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        int contextLength = httpRequest.getContextPath().length();
        final String scriptFilename = httpRequest.getRequestURI().substring(contextLength).substring(1);
        final Binding binding = new Binding();
        binding.setVariable("request", httpRequest);
        binding.setVariable("response", httpResponse);
        binding.setVariable("application", this.sc);
        binding.setVariable("session", httpRequest.getSession(true));
        binding.setVariable("out", httpResponse.getWriter());
        Enumeration paramEnum = request.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            String key = (String)paramEnum.nextElement();
            if (binding.getVariable(key) != null) continue;
            String[] values = request.getParameterValues(key);
            if (values.length == 1) {
                binding.setVariable(key, values[0]);
                continue;
            }
            binding.setVariable(key, values);
        }
        response.setContentType("text/html");
        try {
            Closure closure = new Closure(gse){

                public Object call() {
                    try {
                        return ((GroovyScriptEngine)this.getDelegate()).run(scriptFilename, binding);
                    }
                    catch (ResourceException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            GroovyCategorySupport.use(ServletCategory.class, closure);
        }
        catch (RuntimeException re) {
            Throwable e = re.getCause();
            if (e instanceof ResourceException) {
                httpResponse.sendError(404);
            }
            if (e != null) {
                this.sc.log("An error occurred processing the request", e);
            } else {
                this.sc.log("An error occurred processing the request", (Throwable)re);
            }
            httpResponse.sendError(500);
        }
    }

    private static class ServletCacheEntry {
        private Class servletScriptClass;
        private long lastModified;
        private Map dependencies = new HashMap();

        private ServletCacheEntry() {
        }
    }
}

