package test.org.seasar.jsf.el;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.jsf.el.MethodBindingImpl;

/**
 * @author higa
 *  
 */
public class MethodBindingTest extends S2TestCase {

	private MethodBindingImpl binding_;

	public MethodBindingTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(MethodBindingTest.class);
	}

	public void testRequestParameter() throws Exception {
		getRequest().setParameter("message", "hello");
		binding_.invoke(null, null);
		assertEquals("1", "hello", getRequest().getAttribute("message"));
	}
	
	public void testRequestAttribute() throws Exception {
		getRequest().setAttribute("message", "hello");
		binding_.invoke(null, null);
		assertEquals("1", "hello", getRequest().getAttribute("message"));
	}
	
	public void testSessionAttribute() throws Exception {
		getRequest().getSession().setAttribute("message", "hello");
		binding_.invoke(null, null);
		assertEquals("1", "hello", getRequest().getAttribute("message"));
	}
	
	public void testContainer() throws Exception {
		register("hello", "message");
		binding_.invoke(null, null);
		assertEquals("1", "hello", getRequest().getAttribute("message"));
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		include("MethodBindingTest.dicon");
		binding_ = new MethodBindingImpl("#{helloAction.sayHello}");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}
}