package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.template.NodeHandler;
import org.w3c.dom.Node;

/**
 * @author higa
 *  
 */
public class HtmlInputTextHandler implements NodeHandler {

	public HtmlInputTextHandler() {
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#isHandleable(org.w3c.dom.Node)
	 */
	public boolean isHandleable(Node node) {
		return node.getNodeType() == Node.ELEMENT_NODE
				&& node.getNodeName().equalsIgnoreCase(JsfConstants.INPUT_ELEM)
				&& JsfConstants.TEXT_VALUE.equalsIgnoreCase(node
						.getAttributes().getNamedItem(JsfConstants.TYPE_ATTR)
						.getNodeValue());
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#createComponentFactory(org.w3c.dom.Node)
	 */
	public ComponentFactory createComponentFactory(Node node) {
		return new HtmlInputTextFactory(node);
	}

}