package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.template.NodeHandler;
import org.w3c.dom.Node;

/**
 * @author higa
 *  
 */
public class HtmlCommandLinkHandler implements NodeHandler {

	public HtmlCommandLinkHandler() {
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#isHandleable(org.w3c.dom.Node)
	 */
	public boolean isHandleable(Node node) {
		return node.getNodeType() == Node.ELEMENT_NODE
				&& node.getNodeName()
						.equalsIgnoreCase(JsfConstants.ANCHOR_ELEM)
				&& (node.getAttributes().getNamedItem(JsfConstants.ACTION_ATTR) != null || node
						.getAttributes().getNamedItemNS(
								JsfConstants.BINDING_NSURI,
								JsfConstants.ACTION_ATTR) != null);
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#createComponentFactory(org.w3c.dom.Node)
	 */
	public ComponentFactory createComponentFactory(Node node) {
		return new HtmlCommandLinkFactory(node);
	}

}